"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.canCategorize = canCategorize;
exports.triggerCategorizeActions = triggerCategorizeActions;
var _public = require("@kbn/ui-actions-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function getCompatibleActions(uiActions, field, dataView, trigger) {
  const compatibleActions = await uiActions.getTriggerCompatibleActions(trigger, {
    dataView,
    field
  });
  return compatibleActions;
}
function triggerCategorizeActions(uiActions, field, originatingApp, dataView) {
  if (!dataView) return;
  const triggerOptions = {
    dataView,
    field,
    originatingApp
  };
  uiActions.getTrigger(_public.CATEGORIZE_FIELD_TRIGGER).exec(triggerOptions);
}
async function canCategorize(uiActions, field, dataView) {
  var _field$esTypes;
  if (field.name === '_id' || !(dataView !== null && dataView !== void 0 && dataView.id) || !dataView.isTimeBased() || !((_field$esTypes = field.esTypes) !== null && _field$esTypes !== void 0 && _field$esTypes.includes('text'))) {
    return false;
  }
  const actions = await getCompatibleActions(uiActions, field, dataView, _public.CATEGORIZE_FIELD_TRIGGER);
  return actions.length > 0;
}