"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Demo = Demo;
exports.urlFactory = exports.urlDrilldownActionFactory = exports.mockSupportedTriggers = exports.mockGetTriggerInfo = exports.mockActionFactories = exports.dashboards = exports.dashboardFactory = exports.dashboardDrilldownActionFactory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _mocks = require("@kbn/licensing-plugin/public/mocks");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _dynamic_actions = require("../../dynamic_actions");
var _action_wizard = require("./action_wizard");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const dashboards = [{
  id: 'dashboard1',
  title: 'Dashboard 1'
}, {
  id: 'dashboard2',
  title: 'Dashboard 2'
}];
exports.dashboards = dashboards;
function DashboardDrilldownCollectConfig(props) {
  var _props$config;
  const config = (_props$config = props.config) !== null && _props$config !== void 0 ? _props$config : {
    dashboardId: undefined,
    useCurrentFilters: true,
    useCurrentDateRange: true
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Choose destination dashboard:"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    name: "selectDashboard",
    hasNoInitialSelection: true,
    options: dashboards.map(({
      id,
      title
    }) => ({
      value: id,
      text: title
    })),
    value: config.dashboardId,
    onChange: e => {
      props.onConfig({
        ...config,
        dashboardId: e.target.value
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasChildLabel: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "useCurrentFilters",
    label: "Use current dashboard's filters",
    checked: config.useCurrentFilters,
    onChange: () => props.onConfig({
      ...config,
      useCurrentFilters: !config.useCurrentFilters
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasChildLabel: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "useCurrentDateRange",
    label: "Use current dashboard's date range",
    checked: config.useCurrentDateRange,
    onChange: () => props.onConfig({
      ...config,
      useCurrentDateRange: !config.useCurrentDateRange
    })
  })));
}
const dashboardDrilldownActionFactory = {
  id: 'Dashboard',
  getDisplayName: () => 'Go to Dashboard',
  getIconType: () => 'dashboardApp',
  createConfig: () => {
    return {
      dashboardId: undefined,
      useCurrentFilters: true,
      useCurrentDateRange: true
    };
  },
  isConfigValid: config => {
    if (!config.dashboardId) return false;
    return true;
  },
  CollectConfig: DashboardDrilldownCollectConfig,
  isCompatible(context) {
    return Promise.resolve(true);
  },
  order: 0,
  create: () => ({
    id: 'test',
    execute: async () => alert('Navigate to dashboard!'),
    enhancements: {}
  }),
  supportedTriggers() {
    return [_public.APPLY_FILTER_TRIGGER];
  }
};
exports.dashboardDrilldownActionFactory = dashboardDrilldownActionFactory;
const dashboardFactory = new _dynamic_actions.ActionFactory(dashboardDrilldownActionFactory, {
  getLicense: () => _mocks.licensingMock.createLicense(),
  getFeatureUsageStart: () => _mocks.licensingMock.createStart().featureUsage
});
exports.dashboardFactory = dashboardFactory;
function UrlDrilldownCollectConfig(props) {
  var _props$config2;
  const config = (_props$config2 = props.config) !== null && _props$config2 !== void 0 ? _props$config2 : {
    url: '',
    openInNewTab: false
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Enter target URL"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: "Enter URL",
    name: "url",
    value: config.url,
    onChange: event => props.onConfig({
      ...config,
      url: event.target.value
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasChildLabel: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "openInNewTab",
    label: "Open in new tab?",
    checked: config.openInNewTab,
    onChange: () => props.onConfig({
      ...config,
      openInNewTab: !config.openInNewTab
    })
  })));
}
const urlDrilldownActionFactory = {
  id: 'Url',
  getDisplayName: () => 'Go to URL',
  getIconType: () => 'link',
  createConfig: () => {
    return {
      url: '',
      openInNewTab: false
    };
  },
  isConfigValid: config => {
    if (!config.url) return false;
    return true;
  },
  CollectConfig: UrlDrilldownCollectConfig,
  order: 10,
  isCompatible(context) {
    return Promise.resolve(true);
  },
  create: () => ({}),
  supportedTriggers() {
    return [_public2.VALUE_CLICK_TRIGGER, _public2.SELECT_RANGE_TRIGGER];
  }
};
exports.urlDrilldownActionFactory = urlDrilldownActionFactory;
const urlFactory = new _dynamic_actions.ActionFactory(urlDrilldownActionFactory, {
  getLicense: () => _mocks.licensingMock.createLicense(),
  getFeatureUsageStart: () => _mocks.licensingMock.createStart().featureUsage
});
exports.urlFactory = urlFactory;
const mockActionFactories = [dashboardFactory, urlFactory];
exports.mockActionFactories = mockActionFactories;
const mockSupportedTriggers = [_public2.VALUE_CLICK_TRIGGER, _public2.SELECT_RANGE_TRIGGER, _public.APPLY_FILTER_TRIGGER];
exports.mockSupportedTriggers = mockSupportedTriggers;
const mockGetTriggerInfo = triggerId => {
  var _titleMap$triggerId, _descriptionMap$trigg;
  const titleMap = {
    [_public2.VALUE_CLICK_TRIGGER]: 'Single click',
    [_public2.SELECT_RANGE_TRIGGER]: 'Range selection',
    [_public.APPLY_FILTER_TRIGGER]: 'Apply filter'
  };
  const descriptionMap = {
    [_public2.VALUE_CLICK_TRIGGER]: 'A single point clicked on a visualization',
    [_public2.SELECT_RANGE_TRIGGER]: 'Select a group of values',
    [_public.APPLY_FILTER_TRIGGER]: 'Apply filter description...'
  };
  return {
    id: triggerId,
    title: (_titleMap$triggerId = titleMap[triggerId]) !== null && _titleMap$triggerId !== void 0 ? _titleMap$triggerId : 'Unknown',
    description: (_descriptionMap$trigg = descriptionMap[triggerId]) !== null && _descriptionMap$trigg !== void 0 ? _descriptionMap$trigg : 'Unknown description'
  };
};
exports.mockGetTriggerInfo = mockGetTriggerInfo;
function Demo({
  actionFactories
}) {
  var _state$selectedTrigge2, _state$currentActionF, _state$currentActionF2, _state$currentActionF3, _state$selectedTrigge3, _state$selectedTrigge4;
  const [state, setState] = (0, _react.useState)({});
  function changeActionFactory(newActionFactory) {
    var _state$selectedTrigge;
    if (!newActionFactory) {
      // removing action factory
      return setState({});
    }
    setState({
      currentActionFactory: newActionFactory,
      config: newActionFactory.createConfig({
        triggers: (_state$selectedTrigge = state.selectedTriggers) !== null && _state$selectedTrigge !== void 0 ? _state$selectedTrigge : []
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_action_wizard.ActionWizard, {
    actionFactories: actionFactories,
    config: state.config,
    onConfigChange: newConfig => {
      setState({
        ...state,
        config: newConfig
      });
    },
    onActionFactoryChange: newActionFactory => {
      changeActionFactory(newActionFactory);
    },
    currentActionFactory: state.currentActionFactory,
    context: {
      triggers: (_state$selectedTrigge2 = state.selectedTriggers) !== null && _state$selectedTrigge2 !== void 0 ? _state$selectedTrigge2 : []
    },
    onSelectedTriggersChange: triggers => {
      setState({
        ...state,
        selectedTriggers: triggers
      });
    },
    getTriggerInfo: mockGetTriggerInfo,
    triggers: [_public2.VALUE_CLICK_TRIGGER, _public.APPLY_FILTER_TRIGGER, _public2.SELECT_RANGE_TRIGGER]
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      marginTop: '44px'
    }
  }), /*#__PURE__*/_react.default.createElement("hr", null), /*#__PURE__*/_react.default.createElement("div", null, "Action Factory Id: ", (_state$currentActionF = state.currentActionFactory) === null || _state$currentActionF === void 0 ? void 0 : _state$currentActionF.id), /*#__PURE__*/_react.default.createElement("div", null, "Action Factory Config: ", JSON.stringify(state.config)), /*#__PURE__*/_react.default.createElement("div", null, "Is config valid:", ' ', JSON.stringify((_state$currentActionF2 = (_state$currentActionF3 = state.currentActionFactory) === null || _state$currentActionF3 === void 0 ? void 0 : _state$currentActionF3.isConfigValid(state.config, {
    triggers: (_state$selectedTrigge3 = state.selectedTriggers) !== null && _state$selectedTrigge3 !== void 0 ? _state$selectedTrigge3 : []
  })) !== null && _state$currentActionF2 !== void 0 ? _state$currentActionF2 : false)), /*#__PURE__*/_react.default.createElement("div", null, "Picked trigger: ", (_state$selectedTrigge4 = state.selectedTriggers) === null || _state$selectedTrigge4 === void 0 ? void 0 : _state$selectedTrigge4[0]));
}