"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSpacesData = void 0;
var _react = require("react");
var _kibana_react = require("./kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSpacesData = () => {
  const {
    spaces
  } = (0, _kibana_react.useKibana)().services;
  const [spacesData, setSpacesData] = (0, _react.useState)(undefined);
  const spacesService = spaces === null || spaces === void 0 ? void 0 : spaces.ui.useSpaces();
  (0, _react.useEffect)(() => {
    (async () => {
      const result = await (spacesService === null || spacesService === void 0 ? void 0 : spacesService.spacesDataPromise);
      setSpacesData(result);
    })();
  }, [spaces, spacesService, setSpacesData]);
  return spacesData;
};
exports.useSpacesData = useSpacesData;