"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRulesListColumnSelector = exports.originalRulesListVisibleColumns = void 0;
var _eui = require("@elastic/eui");
var _react = require("react");
var _kibana = require("../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const originalRulesListVisibleColumns = ['ruleName', 'ruleTags', 'ruleExecutionStatusLastDate', 'ruleSnoozeNotify', 'ruleScheduleInterval', 'ruleExecutionStatusLastDuration', 'ruleExecutionPercentile', 'ruleExecutionSuccessRatio', 'ruleExecutionStatus', 'ruleExecutionState'];
exports.originalRulesListVisibleColumns = originalRulesListVisibleColumns;
const RULES_LIST_COLUMNS_KEY = 'triggersActionsUi_rulesListColumns';
const useRulesListColumnSelector = ({
  allRuleColumns,
  rulesListKey = RULES_LIST_COLUMNS_KEY,
  visibleColumns = originalRulesListVisibleColumns
}) => {
  const {
    storage
  } = (0, _kibana.useKibana)().services;
  const storageVisibleColumns = storage === null || storage === void 0 ? void 0 : storage.get(rulesListKey);
  const [localVisibleColumns, setLocalVisibleColumns] = (0, _react.useState)(storageVisibleColumns !== null && storageVisibleColumns !== void 0 ? storageVisibleColumns : visibleColumns);
  const ruleColumnsWithId = (0, _react.useMemo)(() => allRuleColumns.filter(col => col.id != null), [allRuleColumns]);
  const ruleColumnsWithoutId = (0, _react.useMemo)(() => allRuleColumns.filter(col => col.id === undefined), [allRuleColumns]);
  const rulesColumns = (0, _react.useMemo)(() => {
    const columns = localVisibleColumns.map(coldId => {
      var _ruleColumnsWithId$fi;
      const {
        id = '',
        selectorName = '',
        ...colAttr
      } = (_ruleColumnsWithId$fi = ruleColumnsWithId.find(col => col.id === coldId)) !== null && _ruleColumnsWithId$fi !== void 0 ? _ruleColumnsWithId$fi : {};
      return colAttr;
    });
    columns.push(...ruleColumnsWithoutId);
    return columns;
  }, [ruleColumnsWithId, localVisibleColumns, ruleColumnsWithoutId]);
  const rulesListColumnSelector = (0, _react.useMemo)(() => ruleColumnsWithId.map(col => ({
    id: col.id
  })), [ruleColumnsWithId]);
  const persistColumnVisibilityInStorage = (0, _react.useCallback)(col => {
    if (rulesListKey) {
      storage === null || storage === void 0 ? void 0 : storage.set(rulesListKey, col);
    }
  }, [rulesListKey, storage]);
  const rulesListColumnVisibility = (0, _react.useMemo)(() => ({
    visibleColumns: localVisibleColumns,
    setVisibleColumns: col => {
      persistColumnVisibilityInStorage(col);
      setLocalVisibleColumns(col);
    }
  }), [localVisibleColumns, persistColumnVisibilityInStorage]);
  const rulesListColumnsSelectorDisplayValues = (0, _react.useMemo)(() => allRuleColumns.filter(col => col.id != null).reduce((acc, {
    id,
    name,
    selectorName
  }) => {
    if (id) {
      return {
        ...acc,
        [id]: selectorName !== null && selectorName !== void 0 ? selectorName : name
      };
    }
    return acc;
  }, {}), [allRuleColumns]);
  const [ColumnSelector] = (0, _eui.useDataGridColumnSelector)(rulesListColumnSelector, rulesListColumnVisibility, true, rulesListColumnsSelectorDisplayValues);
  return (0, _react.useMemo)(() => [rulesColumns, ColumnSelector], [ColumnSelector, rulesColumns]);
};
exports.useRulesListColumnSelector = useRulesListColumnSelector;