"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesListAutoRefresh = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const flexGroupStyle = {
  marginLeft: 'auto'
};
const getLastUpdateText = lastUpdate => {
  if (!(0, _moment.default)(lastUpdate).isValid()) {
    return '';
  }
  return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListAutoRefresh.lastUpdateText', {
    defaultMessage: 'Updated {lastUpdateText}',
    values: {
      lastUpdateText: (0, _moment.default)(lastUpdate).fromNow()
    }
  });
};
const TEXT_UPDATE_INTERVAL = 60 * 1000;
const DEFAULT_REFRESH_INTERVAL = 5 * 60 * 1000;
const MIN_REFRESH_INTERVAL = 1000;
const RulesListAutoRefresh = props => {
  const {
    lastUpdate,
    initialUpdateInterval = DEFAULT_REFRESH_INTERVAL,
    onRefresh
  } = props;
  const [isPaused, setIsPaused] = (0, _react.useState)(false);
  const [refreshInterval, setRefreshInterval] = (0, _react.useState)(Math.max(initialUpdateInterval, MIN_REFRESH_INTERVAL));
  const [lastUpdateText, setLastUpdateText] = (0, _react.useState)('');
  const cachedOnRefresh = (0, _react.useRef)(() => {});
  const textUpdateTimeout = (0, _react.useRef)();
  const refreshTimeout = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    cachedOnRefresh.current = onRefresh;
  }, [onRefresh]);
  (0, _react.useEffect)(() => {
    setLastUpdateText(getLastUpdateText(lastUpdate));
    const poll = () => {
      textUpdateTimeout.current = window.setTimeout(() => {
        setLastUpdateText(getLastUpdateText(lastUpdate));
        poll();
      }, TEXT_UPDATE_INTERVAL);
    };
    poll();
    return () => {
      if (textUpdateTimeout.current) {
        clearTimeout(textUpdateTimeout.current);
      }
    };
  }, [lastUpdate, setLastUpdateText]);
  (0, _react.useEffect)(() => {
    if (isPaused) {
      return;
    }
    const poll = () => {
      refreshTimeout.current = window.setTimeout(() => {
        cachedOnRefresh.current();
        poll();
      }, refreshInterval);
    };
    poll();
    return () => {
      if (refreshTimeout.current) {
        clearTimeout(refreshTimeout.current);
      }
    };
  }, [isPaused, refreshInterval]);
  const onRefreshChange = (0, _react.useCallback)(({
    isPaused: newIsPaused,
    refreshInterval: newRefreshInterval
  }) => {
    setIsPaused(newIsPaused);
    setRefreshInterval(newRefreshInterval);
  }, [setIsPaused, setRefreshInterval]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "rulesListAutoRefresh",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: flexGroupStyle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "rulesListAutoRefresh-lastUpdateText",
    size: "s",
    color: "subdued"
  }, lastUpdateText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAutoRefreshButton, {
    isPaused: isPaused,
    shortHand: true,
    refreshInterval: refreshInterval,
    onRefreshChange: onRefreshChange
  })));
};
exports.RulesListAutoRefresh = RulesListAutoRefresh;