"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_RRULE_PRESETS = exports.DEFAULT_REPEAT_OPTIONS = void 0;
Object.defineProperty(exports, "I18N_WEEKDAY_OPTIONS", {
  enumerable: true,
  get: function () {
    return _constants.I18N_WEEKDAY_OPTIONS;
  }
});
Object.defineProperty(exports, "ISO_WEEKDAYS", {
  enumerable: true,
  get: function () {
    return _common.ISO_WEEKDAYS;
  }
});
exports.RRULE_WEEKDAYS_TO_ISO_WEEKDAYS = exports.RECURRENCE_END_OPTIONS = exports.ISO_WEEKDAYS_TO_RRULE = void 0;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _types = require("../../../../../../types");
var _constants = require("../../../../../../common/constants");
var _common = require("@kbn/alerting-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RECURRENCE_END_OPTIONS = [{
  id: 'never',
  label: 'Never'
}, {
  id: 'ondate',
  label: 'On date'
}, {
  id: 'afterx',
  label: 'After {x}'
}];
exports.RECURRENCE_END_OPTIONS = RECURRENCE_END_OPTIONS;
const DEFAULT_REPEAT_OPTIONS = [{
  text: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurDaily', {
    defaultMessage: 'Daily'
  }),
  value: _types.RRuleFrequency.DAILY
}, {
  text: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurWeekly', {
    defaultMessage: 'Weekly'
  }),
  value: _types.RRuleFrequency.WEEKLY
}, {
  text: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurMonthly', {
    defaultMessage: 'Monthly'
  }),
  value: _types.RRuleFrequency.MONTHLY
}, {
  text: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurYearly', {
    defaultMessage: 'Yearly'
  }),
  value: _types.RRuleFrequency.YEARLY
}, {
  text: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurCustom', {
    defaultMessage: 'Custom'
  }),
  value: 'CUSTOM'
}];
exports.DEFAULT_REPEAT_OPTIONS = DEFAULT_REPEAT_OPTIONS;
const DEFAULT_RRULE_PRESETS = {
  [_types.RRuleFrequency.DAILY]: {
    interval: 1
  },
  [_types.RRuleFrequency.WEEKLY]: {
    interval: 1
  },
  [_types.RRuleFrequency.MONTHLY]: {
    interval: 1
  },
  [_types.RRuleFrequency.YEARLY]: {
    interval: 1
  }
};
exports.DEFAULT_RRULE_PRESETS = DEFAULT_RRULE_PRESETS;
const ISO_WEEKDAYS_TO_RRULE = {
  1: 'MO',
  2: 'TU',
  3: 'WE',
  4: 'TH',
  5: 'FR',
  6: 'SA',
  7: 'SU'
};
exports.ISO_WEEKDAYS_TO_RRULE = ISO_WEEKDAYS_TO_RRULE;
const RRULE_WEEKDAYS_TO_ISO_WEEKDAYS = (0, _lodash.mapValues)((0, _lodash.invert)(ISO_WEEKDAYS_TO_RRULE), v => Number(v));
exports.RRULE_WEEKDAYS_TO_ISO_WEEKDAYS = RRULE_WEEKDAYS_TO_ISO_WEEKDAYS;