"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NumberField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NumberField = props => {
  const [displayValue, setDisplayValue] = (0, _react.useState)(props.value);
  const min = typeof props.min !== 'undefined' ? props.min : -Infinity;
  const max = typeof props.max !== 'undefined' ? props.max : Infinity;
  const onChange = (0, _react.useCallback)(e => {
    const {
      value
    } = e.target;
    const isValid = !isNaN(Number(value)) && value >= min && value <= max;
    if (isValid || value === '') {
      setDisplayValue(value);
    }
    if (isValid && props.onChange) {
      props.onChange(value);
    }
  }, [props, setDisplayValue, max, min]);
  const onBlur = (0, _react.useCallback)(e => {
    if (isNaN(Number(displayValue)) || displayValue === '') {
      setDisplayValue(props.value);
    }
    if (props.onBlur) props.onBlur(e);
  }, [displayValue, props, setDisplayValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({}, props, {
    value: displayValue,
    onChange: onChange,
    onBlur: onBlur
  }));
};
exports.NumberField = NumberField;