"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleEnabledSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleEnabledSwitch = ({
  item,
  onRuleChanged,
  disableRule,
  enableRule
}) => {
  const [isEnabled, setIsEnabled] = (0, _react.useState)(!item.enabled);
  (0, _react.useEffect)(() => {
    setIsEnabled(item.enabled);
  }, [item.enabled]);
  const [isUpdating, setIsUpdating] = (0, _react.useState)(false);
  return isUpdating ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "enableSpinner",
    size: "m"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "enable",
    disabled: !item.isEditable || !item.enabledInLicense,
    compressed: true,
    checked: isEnabled,
    "data-test-subj": "enableSwitch",
    onChange: async () => {
      setIsUpdating(true);
      const enabled = item.enabled;
      if (enabled) {
        await disableRule({
          ...item,
          enabled
        });
      } else {
        await enableRule({
          ...item,
          enabled
        });
      }
      setIsEnabled(!isEnabled);
      setIsUpdating(false);
      onRuleChanged();
    },
    label: ""
  });
};
exports.RuleEnabledSwitch = RuleEnabledSwitch;