"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LogsList = void 0;
var _suspended_component_with_props = require("../../../lib/suspended_component_with_props");
var _rule_event_log_list_table = require("../../rule_details/components/rule_event_log_list_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GLOBAL_EVENT_LOG_LIST_STORAGE_KEY = 'xpack.triggersActionsUI.globalEventLogList.initialColumns';
const LogsList = ({
  setHeaderActions
}) => {
  return (0, _suspended_component_with_props.suspendedComponentWithProps)(_rule_event_log_list_table.RuleEventLogListTableWithApi, 'xl')({
    ruleId: '*',
    refreshToken: {
      resolve: () => {
        /* noop */
      },
      reject: () => {
        /* noop */
      }
    },
    initialPageSize: 50,
    hasRuleNames: true,
    hasAllSpaceSwitch: true,
    localStorageKey: GLOBAL_EVENT_LOG_LIST_STORAGE_KEY,
    setHeaderActions
  });
};

// eslint-disable-next-line import/no-default-export
exports.LogsList = LogsList;
var _default = LogsList;
exports.default = _default;