"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategoriesSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../../translations"));
var _helpers = require("../../helpers");
var _categories_selector = require("./categories_selector.styles");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderOption = (option, searchValue) => {
  const {
    label,
    count,
    checked
  } = option;
  // Some category names have spaces, but test selectors don't like spaces,
  // Tests are not able to find subjects with spaces, so we need to clean them.
  const idAttr = label.replace(/\s/g, '');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `categories-selector-option-${idAttr}`,
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", {
    css: _categories_selector.styles.categoryName({
      bold: checked === 'on'
    }),
    "data-test-subj": `categories-selector-option-name-${idAttr}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
    search: searchValue
  }, label))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    css: _categories_selector.styles.countBadge
  }, count)));
};
const CategoriesSelectorComponent = ({
  filteredBrowserFields,
  setSelectedCategoryIds,
  selectedCategoryIds
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(open => !open);
  }, []);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const totalCategories = (0, _react.useMemo)(() => Object.keys(filteredBrowserFields).length, [filteredBrowserFields]);
  const categoryOptions = (0, _react.useMemo)(() => {
    const unselectedCategoryIds = Object.keys((0, _lodash.omit)(filteredBrowserFields, selectedCategoryIds)).sort();
    return [...selectedCategoryIds.map(categoryId => ({
      label: categoryId,
      count: (0, _helpers.getFieldCount)(filteredBrowserFields[categoryId]),
      checked: 'on'
    })), ...unselectedCategoryIds.map(categoryId => ({
      label: categoryId,
      count: (0, _helpers.getFieldCount)(filteredBrowserFields[categoryId])
    }))];
  }, [selectedCategoryIds, filteredBrowserFields]);
  const onCategoriesChange = (0, _react.useCallback)(options => {
    setSelectedCategoryIds(options.filter(({
      checked
    }) => checked === 'on').map(({
      label
    }) => label));
  }, [setSelectedCategoryIds]);
  const onKeyDown = (0, _react.useCallback)(keyboardEvent => {
    if ((0, _helpers.isEscape)(keyboardEvent)) {
      // Prevent escape to close the field browser modal after closing the category selector
      keyboardEvent.stopPropagation();
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    "data-test-subj": "categories-selector"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": "categories-filter-button",
      hasActiveFilters: selectedCategoryIds.length > 0,
      iconType: "arrowDown",
      isSelected: isPopoverOpen,
      numActiveFilters: selectedCategoryIds.length,
      numFilters: totalCategories,
      onClick: togglePopover
    }, i18n.CATEGORIES),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: _categories_selector.styles.selectableContainer,
    onKeyDown: onKeyDown,
    "data-test-subj": "categories-selector-container"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": "Searchable categories",
    searchable: true,
    searchProps: {
      'data-test-subj': 'categories-selector-search'
    },
    options: categoryOptions,
    renderOption: renderOption,
    onChange: onCategoriesChange
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list)))));
};
const CategoriesSelector = /*#__PURE__*/_react.default.memo(CategoriesSelectorComponent);
exports.CategoriesSelector = CategoriesSelector;