"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventLogListStatusFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _get_experimental_features = require("../../../../../common/get_experimental_features");
var _event_log_list_status = require("./event_log_list_status");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statusFilters = ['success', 'failure', 'warning', 'unknown'];
const EventLogListStatusFilter = props => {
  const {
    selectedOptions = [],
    onChange = () => {}
  } = props;
  const isRuleUsingExecutionStatus = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('ruleUseExecutionStatus');
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onFilterItemClick = (0, _react.useCallback)(newOption => () => {
    if (selectedOptions.includes(newOption)) {
      onChange(selectedOptions.filter(option => option !== newOption));
      return;
    }
    onChange([...selectedOptions, newOption]);
  }, [selectedOptions, onChange]);
  const onClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(prevIsOpen => !prevIsOpen);
  }, [setIsPopoverOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": "eventLogStatusFilterButton",
      iconType: "arrowDown",
      hasActiveFilters: selectedOptions.length > 0,
      numActiveFilters: selectedOptions.length,
      numFilters: selectedOptions.length,
      onClick: onClick
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.eventLogStatusFilterLabel",
      defaultMessage: "Response"
    }))
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, statusFilters.map(status => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      key: status,
      "data-test-subj": `eventLogStatusFilter-${status}`,
      onClick: onFilterItemClick(status),
      checked: selectedOptions.includes(status) ? 'on' : undefined
    }, /*#__PURE__*/_react.default.createElement(_event_log_list_status.EventLogListStatus, {
      status: status,
      useExecutionStatus: isRuleUsingExecutionStatus
    }));
  }))));
};
exports.EventLogListStatusFilter = EventLogListStatusFilter;