"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _types = require("../../../../../types");
var i18n = _interopRequireWildcard(require("../translations"));
var _context = require("../context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_NUMBER_FORMAT = 'format:number:defaultPattern';
const containerStyles = {
  display: 'inline-block',
  position: 'relative'
};
const selectedIdsToTimelineItemMapper = (alerts, rowSelection) => {
  return Array.from(rowSelection.keys()).map(rowIndex => {
    var _alert$ALERT_CASE_IDS, _alert$ALERT_WORKFLOW;
    const alert = alerts[rowIndex];
    return {
      _id: alert._id,
      _index: alert._index,
      data: [{
        field: _ruleDataUtils.ALERT_RULE_NAME,
        value: alert[_ruleDataUtils.ALERT_RULE_NAME]
      }, {
        field: _ruleDataUtils.ALERT_RULE_UUID,
        value: alert[_ruleDataUtils.ALERT_RULE_UUID]
      }, {
        field: _ruleDataUtils.ALERT_CASE_IDS,
        value: (_alert$ALERT_CASE_IDS = alert[_ruleDataUtils.ALERT_CASE_IDS]) !== null && _alert$ALERT_CASE_IDS !== void 0 ? _alert$ALERT_CASE_IDS : []
      }, {
        field: _ruleDataUtils.ALERT_WORKFLOW_TAGS,
        value: (_alert$ALERT_WORKFLOW = alert[_ruleDataUtils.ALERT_WORKFLOW_TAGS]) !== null && _alert$ALERT_WORKFLOW !== void 0 ? _alert$ALERT_WORKFLOW : []
      }],
      ecs: {
        _id: alert._id,
        _index: alert._index
      }
    };
  });
};
const useBulkActionsToMenuPanelMapper = (panels, setIsBulkActionsLoading, clearSelection, refresh, alerts, closeIfPopoverIsOpen) => {
  const [{
    isAllSelected,
    rowSelection
  }] = (0, _react.useContext)(_context.BulkActionsContext);
  const bulkActionsPanels = (0, _react.useMemo)(() => {
    const bulkActionPanelsToReturn = [];
    for (const panel of panels) {
      const selectedAlertItems = selectedIdsToTimelineItemMapper(alerts, rowSelection);
      if (panel.items) {
        const newItems = panel.items.map(item => {
          const isDisabled = isAllSelected && item.disableOnQuery;
          return {
            key: item.key,
            'data-test-subj': item['data-test-subj'],
            disabled: isDisabled,
            onClick: item.onClick ? () => {
              var _item$onClick;
              closeIfPopoverIsOpen();
              (_item$onClick = item.onClick) === null || _item$onClick === void 0 ? void 0 : _item$onClick.call(item, selectedAlertItems, isAllSelected, setIsBulkActionsLoading, clearSelection, refresh);
            } : undefined,
            name: isDisabled && item.disabledLabel ? item.disabledLabel : item.label,
            panel: item.panel
          };
        });
        bulkActionPanelsToReturn.push({
          ...panel,
          items: newItems
        });
      } else {
        const ContentPanel = panel.renderContent({
          alertItems: selectedAlertItems,
          isAllSelected,
          setIsBulkActionsLoading,
          clearSelection,
          refresh,
          closePopoverMenu: closeIfPopoverIsOpen
        });
        bulkActionPanelsToReturn.push({
          ...panel,
          content: ContentPanel
        });
      }
    }
    return bulkActionPanelsToReturn;
  }, [alerts, clearSelection, isAllSelected, panels, refresh, rowSelection, setIsBulkActionsLoading, closeIfPopoverIsOpen]);
  return bulkActionsPanels;
};
const BulkActionsComponent = ({
  totalItems,
  panels,
  alerts,
  setIsBulkActionsLoading,
  clearSelection,
  refresh
}) => {
  const [{
    rowSelection,
    isAllSelected
  }, updateSelectedRows] = (0, _react.useContext)(_context.BulkActionsContext);
  const [isActionsPopoverOpen, setIsActionsPopoverOpen] = (0, _react.useState)(false);
  const [defaultNumberFormat] = (0, _public.useUiSetting$)(DEFAULT_NUMBER_FORMAT);
  const [showClearSelection, setShowClearSelectiong] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    setShowClearSelectiong(isAllSelected);
  }, [isAllSelected]);
  const selectedCount = rowSelection.size;
  const formattedTotalCount = (0, _react.useMemo)(() => (0, _numeral.default)(totalItems).format(defaultNumberFormat), [defaultNumberFormat, totalItems]);
  const formattedSelectedEventsCount = (0, _react.useMemo)(() => (0, _numeral.default)(selectedCount).format(defaultNumberFormat), [defaultNumberFormat, selectedCount]);
  const toggleIsActionOpen = (0, _react.useCallback)(() => {
    setIsActionsPopoverOpen(currentIsOpen => !currentIsOpen);
  }, [setIsActionsPopoverOpen]);
  const closeActionPopover = (0, _react.useCallback)(() => {
    setIsActionsPopoverOpen(false);
  }, [setIsActionsPopoverOpen]);
  const closeIfPopoverIsOpen = (0, _react.useCallback)(() => {
    if (isActionsPopoverOpen) {
      setIsActionsPopoverOpen(false);
    }
  }, [isActionsPopoverOpen]);
  const bulkActionPanels = useBulkActionsToMenuPanelMapper(panels, setIsBulkActionsLoading, clearSelection, refresh, alerts, closeIfPopoverIsOpen);
  const toggleSelectAll = (0, _react.useCallback)(() => {
    if (!showClearSelection) {
      updateSelectedRows({
        action: _types.BulkActionsVerbs.selectAll
      });
    } else {
      updateSelectedRows({
        action: _types.BulkActionsVerbs.clear
      });
    }
  }, [showClearSelection, updateSelectedRows]);
  const selectedAlertsText = (0, _react.useMemo)(() => showClearSelection ? i18n.SELECTED_ALERTS(formattedTotalCount, totalItems) : i18n.SELECTED_ALERTS(formattedSelectedEventsCount, selectedCount), [showClearSelection, formattedTotalCount, formattedSelectedEventsCount, totalItems, selectedCount]);
  const selectClearAllAlertsText = (0, _react.useMemo)(() => showClearSelection ? i18n.CLEAR_SELECTION : i18n.SELECT_ALL_ALERTS(formattedTotalCount, totalItems), [showClearSelection, formattedTotalCount, totalItems]);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: containerStyles,
    "data-test-subj": "bulk-actions-button-container",
    "aria-hidden": true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isActionsPopoverOpen,
    anchorPosition: "upCenter",
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": "selectedShowBulkActions",
      "data-test-subj": "selectedShowBulkActionsButton",
      size: "xs",
      iconType: "arrowDown",
      iconSide: "right",
      color: "primary",
      onClick: toggleIsActionOpen
    }, selectedAlertsText),
    closePopover: closeActionPopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    size: "s",
    initialPanelId: 0,
    panels: bulkActionPanels
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    "aria-label": "selectAllAlerts",
    "data-test-subj": "selectAllAlertsButton",
    iconType: showClearSelection ? 'cross' : 'pagesSelect',
    onClick: toggleSelectAll
  }, selectClearAllAlertsText));
};

// disabled to be able lazy load
// eslint-disable-next-line import/no-default-export
var _default = /*#__PURE__*/_react.default.memo(BulkActionsComponent);
exports.default = _default;
module.exports = exports.default;