"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AlertSummaryWidget = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_load_alert_summary = require("../../hooks/use_load_alert_summary");
var _components = require("./components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertSummaryWidget = ({
  chartProps,
  featureIds,
  filter,
  fullSize,
  onClick = () => {},
  timeRange
}) => {
  const {
    alertSummary: {
      activeAlertCount,
      activeAlerts,
      recoveredAlertCount
    },
    isLoading,
    error
  } = (0, _use_load_alert_summary.useLoadAlertSummary)({
    featureIds,
    filter,
    timeRange
  });
  if (isLoading) return /*#__PURE__*/_react.default.createElement(_components.AlertSummaryWidgetLoader, {
    fullSize: fullSize
  });
  if (error) return /*#__PURE__*/_react.default.createElement(_components.AlertSummaryWidgetError, null);
  return fullSize ?
  // Only show full size version if there is data
  activeAlertCount || recoveredAlertCount ? /*#__PURE__*/_react.default.createElement(_components.AlertSummaryWidgetFullSize, {
    activeAlertCount: activeAlertCount,
    activeAlerts: activeAlerts,
    chartProps: chartProps,
    dateFormat: timeRange.dateFormat,
    recoveredAlertCount: recoveredAlertCount
  }) : null : /*#__PURE__*/_react.default.createElement(_components.AlertSummaryWidgetCompact, {
    activeAlertCount: activeAlertCount,
    activeAlerts: activeAlerts,
    chartProps: chartProps,
    onClick: onClick,
    recoveredAlertCount: recoveredAlertCount,
    timeRangeTitle: timeRange.title
  });
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.AlertSummaryWidget = AlertSummaryWidget;