"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleTypeCompare = ruleTypeCompare;
exports.ruleTypeGroupCompare = ruleTypeGroupCompare;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ruleTypeGroupCompare(left, right, groupNames) {
  const groupNameA = left[0];
  const groupNameB = right[0];
  const leftRuleTypesList = left[1];
  const rightRuleTypesList = right[1];
  const hasEnabledRuleTypeInListLeft = leftRuleTypesList.find(ruleTypeItem => ruleTypeItem.checkEnabledResult.isEnabled) !== undefined;
  const hasEnabledRuleTypeInListRight = rightRuleTypesList.find(ruleTypeItem => ruleTypeItem.checkEnabledResult.isEnabled) !== undefined;
  if (hasEnabledRuleTypeInListLeft && !hasEnabledRuleTypeInListRight) {
    return -1;
  }
  if (!hasEnabledRuleTypeInListLeft && hasEnabledRuleTypeInListRight) {
    return 1;
  }
  return groupNames ? groupNames.get(groupNameA).localeCompare(groupNames.get(groupNameB)) : groupNameA.localeCompare(groupNameB);
}
function ruleTypeCompare(a, b) {
  if (a.checkEnabledResult.isEnabled === true && b.checkEnabledResult.isEnabled === false) {
    return -1;
  }
  if (a.checkEnabledResult.isEnabled === false && b.checkEnabledResult.isEnabled === true) {
    return 1;
  }
  return a.name.localeCompare(b.name);
}