"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkUpdateAPIKey = bulkUpdateAPIKey;
exports.updateAPIKey = updateAPIKey;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function updateAPIKey({
  id,
  http
}) {
  return http.post(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/rule/${encodeURIComponent(id)}/_update_api_key`);
}
function bulkUpdateAPIKey({
  ids,
  filter,
  http
}) {
  let body;
  try {
    body = JSON.stringify({
      ids: ids !== null && ids !== void 0 && ids.length ? ids : undefined,
      ...(filter ? {
        filter: JSON.stringify(filter)
      } : {}),
      operations: [{
        operation: 'set',
        field: 'apiKey'
      }]
    });
  } catch (e) {
    throw new Error(`Unable to parse bulk update API key params: ${e}`);
  }
  return http.post(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/rules/_bulk_edit`, {
    body
  });
}