"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadRuleState = loadRuleState;
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _ioTs = require("io-ts");
var _common = require("@kbn/alerting-plugin/common");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteBodyRes = ({
  rule_type_state: alertTypeState,
  alerts: alertInstances,
  previous_started_at: previousStartedAt,
  ...rest
}) => ({
  ...rest,
  alertTypeState,
  alertInstances,
  previousStartedAt
});
async function loadRuleState({
  http,
  ruleId
}) {
  return await http.get(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/rule/${ruleId}/state`).then(state => state ? rewriteBodyRes(state) : {}).then(state => {
    return (0, _pipeable.pipe)(_common.ruleStateSchema.decode(state), (0, _Either.fold)(e => {
      throw new Error(`Rule "${ruleId}" has invalid state`);
    }, _ioTs.identity));
  });
}