"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadRulesWithKueryFilter = loadRulesWithKueryFilter;
var _constants = require("../../constants");
var _map_filters_to_kuery_node = require("./map_filters_to_kuery_node");
var _rules_helpers = require("./rules_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function loadRulesWithKueryFilter({
  http,
  page,
  searchText,
  typesFilter,
  actionTypesFilter,
  ruleExecutionStatusesFilter,
  ruleLastRunOutcomesFilter,
  ruleParamsFilter,
  ruleStatusesFilter,
  tagsFilter,
  sort = {
    field: 'name',
    direction: 'asc'
  }
}) {
  const filtersKueryNode = (0, _map_filters_to_kuery_node.mapFiltersToKueryNode)({
    typesFilter,
    actionTypesFilter,
    tagsFilter,
    ruleExecutionStatusesFilter,
    ruleLastRunOutcomesFilter,
    ruleParamsFilter,
    ruleStatusesFilter,
    searchText
  });
  const res = await http.post(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/rules/_find`, {
    body: JSON.stringify({
      page: page.index + 1,
      per_page: page.size,
      ...(filtersKueryNode ? {
        filter: JSON.stringify(filtersKueryNode)
      } : {}),
      sort_field: sort.field,
      sort_order: sort.direction
    })
  });
  return {
    page: res.page,
    perPage: res.per_page,
    total: res.total,
    data: (0, _rules_helpers.rewriteRulesResponseRes)(res.data)
  };
}