"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadRuleTypes = loadRuleTypes;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteResponseRes = results => {
  return results.map(item => rewriteBodyReq(item));
};
const rewriteBodyReq = ({
  enabled_in_license: enabledInLicense,
  recovery_action_group: recoveryActionGroup,
  action_groups: actionGroups,
  default_action_group_id: defaultActionGroupId,
  minimum_license_required: minimumLicenseRequired,
  action_variables: actionVariables,
  authorized_consumers: authorizedConsumers,
  rule_task_timeout: ruleTaskTimeout,
  does_set_recovery_context: doesSetRecoveryContext,
  default_schedule_interval: defaultScheduleInterval,
  has_get_summarized_alerts: hasGetSummarizedAlerts,
  has_fields_for_a_a_d: hasFieldsForAAD,
  ...rest
}) => ({
  enabledInLicense,
  recoveryActionGroup,
  actionGroups,
  defaultActionGroupId,
  minimumLicenseRequired,
  actionVariables,
  authorizedConsumers,
  ruleTaskTimeout,
  doesSetRecoveryContext,
  defaultScheduleInterval,
  hasGetSummarizedAlerts,
  hasFieldsForAAD,
  ...rest
});
async function loadRuleTypes({
  http
}) {
  const res = await http.get(`${_constants.BASE_ALERTING_API_PATH}/rule_types`);
  return rewriteResponseRes(res);
}