"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadRuleTypesQuery = void 0;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _common = require("@kbn/alerting-plugin/common");
var _rule_types = require("../lib/rule_api/rule_types");
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFilteredIndex = (data, filteredRuleTypes) => {
  const index = new Map();
  for (const ruleType of data) {
    index.set(ruleType.id, ruleType);
  }
  let filteredIndex = index;
  if (filteredRuleTypes !== null && filteredRuleTypes !== void 0 && filteredRuleTypes.length) {
    filteredIndex = new Map([...index].filter(([k, v]) => {
      return filteredRuleTypes.includes(v.id);
    }));
  }
  return filteredIndex;
};
const useLoadRuleTypesQuery = props => {
  const {
    filteredRuleTypes
  } = props;
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const queryFn = () => {
    return (0, _rule_types.loadRuleTypes)({
      http
    });
  };
  const onErrorFn = () => {
    toasts.addDanger(_i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.unableToLoadRuleTypesMessage', {
      defaultMessage: 'Unable to load rule types'
    }));
  };
  const {
    data,
    isSuccess,
    isFetching,
    isInitialLoading,
    isLoading
  } = (0, _reactQuery.useQuery)({
    queryKey: ['loadRuleTypes'],
    queryFn,
    onError: onErrorFn,
    refetchOnWindowFocus: false
  });
  const filteredIndex = data ? getFilteredIndex(data, filteredRuleTypes) : new Map();
  const hasAnyAuthorizedRuleType = filteredIndex.size > 0;
  const authorizedRuleTypes = [...filteredIndex.values()];
  const authorizedToCreateAnyRules = authorizedRuleTypes.some(ruleType => {
    var _ruleType$authorizedC;
    return (_ruleType$authorizedC = ruleType.authorizedConsumers[_common.ALERTS_FEATURE_ID]) === null || _ruleType$authorizedC === void 0 ? void 0 : _ruleType$authorizedC.all;
  });
  return {
    ruleTypesState: {
      initialLoad: isLoading || isInitialLoading,
      isLoading: isLoading || isFetching,
      data: filteredIndex
    },
    hasAnyAuthorizedRuleType,
    authorizedRuleTypes,
    authorizedToCreateAnyRules,
    isSuccess
  };
};
exports.useLoadRuleTypesQuery = useLoadRuleTypesQuery;