"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormTestProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _connector_context = require("../context/connector_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FormTestProviderComponent = ({
  children,
  defaultValue,
  onSubmit,
  connectorServices = {
    validateEmailAddresses: jest.fn()
  }
}) => {
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue
  });
  const {
    submit
  } = form;
  const onClick = (0, _react.useCallback)(async () => {
    const res = await submit();
    if (onSubmit) {
      onSubmit(res);
    }
  }, [onSubmit, submit]);
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_connector_context.ConnectorProvider, {
    value: {
      services: connectorServices
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form
  }, children), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "form-test-provide-submit",
    onClick: onClick
  })));
};
FormTestProviderComponent.displayName = 'FormTestProvider';
const FormTestProvider = /*#__PURE__*/_react.default.memo(FormTestProviderComponent);
exports.FormTestProvider = FormTestProvider;