"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesSettingsModalFormRight = exports.RulesSettingsModalFormLeft = exports.RulesSettingsModal = exports.RulesSettingsErrorPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../../common/lib/kibana");
var _rules_settings_flapping_form_section = require("./rules_settings_flapping_form_section");
var _use_get_flapping_settings = require("../../hooks/use_get_flapping_settings");
var _use_update_flapping_settings = require("../../hooks/use_update_flapping_settings");
var _center_justified_spinner = require("../center_justified_spinner");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const flappingDescription = _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.modal.flappingDetectionDescription', {
  defaultMessage: 'Detect alerts that switch quickly between active and recovered states and reduce unwanted noise for these flapping alerts.'
});
const flappingOnLabel = _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.modal.flappingOnLabel', {
  defaultMessage: 'On (recommended)'
});
const flappingOffLabel = _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.modal.flappingOffLabel', {
  defaultMessage: 'Off'
});
const RulesSettingsErrorPrompt = /*#__PURE__*/(0, _react.memo)(() => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "rulesSettingsErrorPrompt",
    color: "danger",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.rulesSettings.modal.errorPromptTitle",
      defaultMessage: "Unable to load your rules settings"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.rulesSettings.modal.errorPromptBody",
      defaultMessage: "There was an error loading your rules settings. Contact your administrator for help"
    }))
  });
});
exports.RulesSettingsErrorPrompt = RulesSettingsErrorPrompt;
const RulesSettingsModalFormLeft = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    settings,
    onChange,
    isSwitchDisabled
  } = props;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, flappingDescription))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "rulesSettingsModalEnableSwitch",
    label: settings.enabled ? flappingOnLabel : flappingOffLabel,
    checked: settings.enabled,
    disabled: isSwitchDisabled,
    onChange: onChange
  }))));
});
exports.RulesSettingsModalFormLeft = RulesSettingsModalFormLeft;
const RulesSettingsModalFormRight = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    settings,
    onChange
  } = props;
  if (!settings) {
    return null;
  }
  if (!settings.enabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": "rulesSettingsModalFlappingOffPrompt"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      borderRadius: "none",
      color: "subdued",
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.rulesSettings.flapping.flappingSettingsOffDescription",
      defaultMessage: "Alert flapping detection is off. Alerts will be generated based on the rule interval, which might result in higher alert volumes."
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_rules_settings_flapping_form_section.RulesSettingsFlappingFormSection, {
    flappingSettings: settings,
    onChange: onChange
  }));
});
exports.RulesSettingsModalFormRight = RulesSettingsModalFormRight;
const RulesSettingsModal = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    isVisible,
    onClose,
    setUpdatingRulesSettings,
    onSave
  } = props;
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const {
    rulesSettings: {
      show,
      save,
      writeFlappingSettingsUI,
      readFlappingSettingsUI
    }
  } = capabilities;
  const [settings, setSettings] = (0, _react.useState)();
  const {
    isLoading,
    isError: hasError
  } = (0, _use_get_flapping_settings.useGetFlappingSettings)({
    enabled: isVisible,
    onSuccess: fetchedSettings => {
      if (!settings) {
        setSettings({
          enabled: fetchedSettings.enabled,
          lookBackWindow: fetchedSettings.lookBackWindow,
          statusChangeThreshold: fetchedSettings.statusChangeThreshold
        });
      }
    }
  });
  const {
    mutate
  } = (0, _use_update_flapping_settings.useUpdateFlappingSettings)({
    onSave,
    onClose,
    setUpdatingRulesSettings
  });

  // In the future when we have more settings sub-features, we should
  // disassociate the rule settings capabilities (save, show) from the
  // sub-feature capabilities (writeXSettingsUI).
  const canWriteFlappingSettings = save && writeFlappingSettingsUI && !hasError;
  const canShowFlappingSettings = show && readFlappingSettingsUI;
  const handleSettingsChange = (key, value) => {
    if (!settings) {
      return;
    }
    const newSettings = {
      ...settings,
      [key]: value
    };
    setSettings({
      ...newSettings,
      statusChangeThreshold: Math.min(newSettings.lookBackWindow, newSettings.statusChangeThreshold)
    });
  };
  const handleSave = () => {
    if (!settings) {
      return;
    }
    mutate(settings);
  };
  if (!isVisible) {
    return null;
  }
  const maybeRenderForm = () => {
    if (hasError || !canShowFlappingSettings) {
      return /*#__PURE__*/_react.default.createElement(RulesSettingsErrorPrompt, null);
    }
    if (!settings || isLoading) {
      return /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, null);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_rules_settings_flapping_form_section.RulesSettingsFlappingTitle, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(RulesSettingsModalFormLeft, {
      isSwitchDisabled: !canWriteFlappingSettings,
      settings: settings,
      onChange: e => handleSettingsChange('enabled', e.target.checked)
    }), /*#__PURE__*/_react.default.createElement(RulesSettingsModalFormRight, {
      settings: settings,
      onChange: (key, value) => handleSettingsChange(key, value)
    })));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "data-test-subj": "rulesSettingsModal",
    onClose: onClose,
    maxWidth: 880
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    component: "h3"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.rulesSettings.modal.title",
    defaultMessage: "Rule settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.modal.calloutMessage', {
      defaultMessage: 'Apply to all rules within the current space.'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), maybeRenderForm(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "rulesSettingsModalCancelButton",
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.rulesSettings.modal.cancelButton",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    "data-test-subj": "rulesSettingsModalSaveButton",
    onClick: handleSave,
    disabled: !canWriteFlappingSettings
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.rulesSettings.modal.saveButton",
    defaultMessage: "Save"
  }))));
});
exports.RulesSettingsModal = RulesSettingsModal;