"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandedRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _mlStringHash = require("@kbn/ml-string-hash");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _expanded_row_details_pane = require("./expanded_row_details_pane");
var _expanded_row_json_pane = require("./expanded_row_json_pane");
var _expanded_row_messages_pane = require("./expanded_row_messages_pane");
var _expanded_row_preview_pane = require("./expanded_row_preview_pane");
var _expanded_row_health_pane = require("./expanded_row_health_pane");
var _transform_health_colored_dot = require("./transform_health_colored_dot");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getItemDescription(value) {
  if (typeof value === 'object') {
    return JSON.stringify(value);
  }
  return value.toString();
}
const ExpandedRow = ({
  item,
  onAlertEdit
}) => {
  var _item$alerting_rules;
  const stateValues = {
    ...item.stats
  };
  delete stateValues.stats;
  delete stateValues.checkpointing;
  const stateItems = [];
  stateItems.push({
    title: 'ID',
    description: item.id
  }, {
    title: 'state',
    description: item.stats.state
  });
  if (item.stats.node !== undefined) {
    stateItems.push({
      title: 'node.name',
      description: item.stats.node.name
    });
  }
  if (item.stats.health !== undefined) {
    stateItems.push({
      title: 'health',
      description: /*#__PURE__*/_react.default.createElement(_transform_health_colored_dot.TransformHealthColoredDot, {
        healthStatus: item.stats.health.status
      })
    });
  }
  const state = {
    title: 'State',
    items: stateItems,
    position: 'right'
  };
  const configItems = (0, _react.useMemo)(() => {
    var _item$config$descript, _formatHumanReadableD, _item$config$settings;
    const configs = [{
      title: 'transform_id',
      description: item.id
    }, {
      title: 'transform_version',
      description: item.config.version
    }, {
      title: 'description',
      description: (_item$config$descript = item.config.description) !== null && _item$config$descript !== void 0 ? _item$config$descript : ''
    }, {
      title: 'create_time',
      description: (_formatHumanReadableD = (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)((0, _momentTimezone.default)(item.config.create_time).unix() * 1000)) !== null && _formatHumanReadableD !== void 0 ? _formatHumanReadableD : ''
    }, {
      title: 'source_index',
      description: Array.isArray(item.config.source.index) ? item.config.source.index[0] : item.config.source.index
    }, {
      title: 'destination_index',
      description: Array.isArray(item.config.dest.index) ? item.config.dest.index[0] : item.config.dest.index
    }, {
      title: 'authorization',
      description: item.config.authorization ? JSON.stringify(item.config.authorization) : ''
    }];
    if ((0, _mlIsDefined.isDefined)((_item$config$settings = item.config.settings) === null || _item$config$settings === void 0 ? void 0 : _item$config$settings.num_failure_retries)) {
      var _item$config$settings2, _item$config$settings3;
      configs.push({
        title: 'num_failure_retries',
        description: (_item$config$settings2 = (_item$config$settings3 = item.config.settings) === null || _item$config$settings3 === void 0 ? void 0 : _item$config$settings3.num_failure_retries) !== null && _item$config$settings2 !== void 0 ? _item$config$settings2 : ''
      });
    }
    return configs;

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [item === null || item === void 0 ? void 0 : item.config]);
  const general = {
    title: 'General',
    items: configItems,
    position: 'left'
  };
  const checkpointingItems = [];
  if (item.stats.checkpointing.changes_last_detected_at !== undefined) {
    checkpointingItems.push({
      title: 'changes_last_detected_at',
      description: (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(item.stats.checkpointing.changes_last_detected_at)
    });
  }
  if (item.stats.checkpointing.last !== undefined) {
    checkpointingItems.push({
      title: 'last.checkpoint',
      description: item.stats.checkpointing.last.checkpoint
    });
    if (item.stats.checkpointing.last.timestamp_millis !== undefined) {
      checkpointingItems.push({
        title: 'last.timestamp',
        description: (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(item.stats.checkpointing.last.timestamp_millis)
      });
      checkpointingItems.push({
        title: 'last.timestamp_millis',
        description: item.stats.checkpointing.last.timestamp_millis
      });
    }
  }
  if (item.stats.checkpointing.last_search_time !== undefined) {
    checkpointingItems.push({
      title: 'last_search_time',
      description: (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(item.stats.checkpointing.last_search_time)
    });
  }
  if (item.stats.checkpointing.next !== undefined) {
    checkpointingItems.push({
      title: 'next.checkpoint',
      description: item.stats.checkpointing.next.checkpoint
    });
    if (item.stats.checkpointing.next.checkpoint_progress !== undefined) {
      checkpointingItems.push({
        title: 'next.checkpoint_progress.total_docs',
        description: item.stats.checkpointing.next.checkpoint_progress.total_docs
      });
      checkpointingItems.push({
        title: 'next.checkpoint_progress.docs_remaining',
        description: item.stats.checkpointing.next.checkpoint_progress.docs_remaining
      });
      checkpointingItems.push({
        title: 'next.checkpoint_progress.percent_complete',
        description: item.stats.checkpointing.next.checkpoint_progress.percent_complete
      });
    }
  }
  if (item.stats.checkpointing.operations_behind !== undefined) {
    checkpointingItems.push({
      title: 'operations_behind',
      description: item.stats.checkpointing.operations_behind
    });
  }
  const alertRuleItems = (_item$alerting_rules = item.alerting_rules) === null || _item$alerting_rules === void 0 ? void 0 : _item$alerting_rules.map(rule => {
    return {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        iconType: 'documentEdit',
        iconSide: 'left',
        onClick: () => {
          onAlertEdit(rule);
        },
        flush: "left",
        size: 'xs',
        iconSize: 's'
      }, rule.name),
      description: rule.executionStatus.status
    };
  });
  const checkpointing = {
    title: 'Checkpointing',
    items: checkpointingItems,
    position: 'right'
  };
  const alertingRules = {
    title: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.alertRulesTitle', {
      defaultMessage: 'Alert rules'
    }),
    items: alertRuleItems,
    position: 'right'
  };
  const stats = {
    title: 'Stats',
    items: Object.entries(item.stats.stats).map(s => {
      return {
        title: s[0].toString(),
        description: getItemDescription(s[1])
      };
    }),
    position: 'left'
  };
  const tabId = (0, _mlStringHash.stringHash)(item.id);
  const tabs = [{
    id: `transform-details-tab-${tabId}`,
    'data-test-subj': 'transformDetailsTab',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.tabs.transformDetailsLabel', {
      defaultMessage: 'Details'
    }),
    content: /*#__PURE__*/_react.default.createElement(_expanded_row_details_pane.ExpandedRowDetailsPane, {
      sections: [general, state, checkpointing, ...(alertingRules.items ? [alertingRules] : [])],
      dataTestSubj: 'transformDetailsTabContent'
    })
  }, {
    id: `transform-stats-tab-${tabId}`,
    'data-test-subj': 'transformStatsTab',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.tabs.transformStatsLabel', {
      defaultMessage: 'Stats'
    }),
    content: /*#__PURE__*/_react.default.createElement(_expanded_row_details_pane.ExpandedRowDetailsPane, {
      sections: [stats],
      dataTestSubj: 'transformStatsTabContent'
    })
  }, {
    id: `transform-json-tab-${tabId}`,
    'data-test-subj': 'transformJsonTab',
    name: 'JSON',
    content: /*#__PURE__*/_react.default.createElement(_expanded_row_json_pane.ExpandedRowJsonPane, {
      json: item.config
    })
  }, ...(item.stats.health ? [{
    id: `transform-health-tab-${tabId}`,
    'data-test-subj': 'transformHealthTab',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.tabs.transformHealthLabel', {
      defaultMessage: 'Health'
    }),
    content: /*#__PURE__*/_react.default.createElement(_expanded_row_health_pane.ExpandedRowHealthPane, {
      health: item.stats.health
    })
  }] : []), {
    id: `transform-messages-tab-${tabId}`,
    'data-test-subj': 'transformMessagesTab',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.tabs.transformMessagesLabel', {
      defaultMessage: 'Messages'
    }),
    content: /*#__PURE__*/_react.default.createElement(_expanded_row_messages_pane.ExpandedRowMessagesPane, {
      transformId: item.id
    })
  }, {
    id: `transform-preview-tab-${tabId}`,
    'data-test-subj': 'transformPreviewTab',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.tabs.transformPreviewLabel', {
      defaultMessage: 'Preview'
    }),
    content: /*#__PURE__*/_react.default.createElement(_expanded_row_preview_pane.ExpandedRowPreviewPane, {
      transformConfig: item.config
    })
  }];

  // Using `expand=false` here so the tabs themselves don't spread
  // across the full width. The 100% width is used so the bottom line
  // as well as the tab content spans across the full width,
  // even if the tab content wouldn't extend to the full width.
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    size: "s",
    tabs: tabs,
    initialSelectedTab: tabs[0],
    onTabClick: () => {},
    expand: false,
    css: (0, _react2.css)`
        width: 100%;

        .euiTable {
          background-color: transparent;
        }
      `,
    "data-test-subj": "transformExpandedRowTabbedContent"
  });
};
exports.ExpandedRow = ExpandedRow;