"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditTransformIngestPipeline = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _type_guards = require("../../../../../../common/api_schemas/type_guards");
var _use_api = require("../../../../hooks/use_api");
var _edit_transform_flyout_form_text_input = require("./edit_transform_flyout_form_text_input");
var _use_edit_transform_flyout = require("./use_edit_transform_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ingestPipelineLabel = _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormDestinationIngestPipelineLabel', {
  defaultMessage: 'Ingest Pipeline'
});
const EditTransformIngestPipeline = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    errorMessages,
    value
  } = (0, _use_edit_transform_flyout.useEditTransformFlyout)('destinationIngestPipeline');
  const {
    formField
  } = (0, _use_edit_transform_flyout.useEditTransformFlyout)('actions');
  const api = (0, _use_api.useApi)();
  const [ingestPipelineNames, setIngestPipelineNames] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  (0, _react.useEffect)(function fetchPipelinesOnMount() {
    let unmounted = false;
    async function getIngestPipelineNames() {
      try {
        const ingestPipelines = await api.getEsIngestPipelines();
        if (!unmounted && (0, _type_guards.isEsIngestPipelines)(ingestPipelines)) {
          setIngestPipelineNames(ingestPipelines.map(({
            name
          }) => name));
        }
      } finally {
        if (!unmounted) {
          setIsLoading(false);
        }
      }
    }
    getIngestPipelineNames();
    return () => {
      unmounted = true;
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null,
  // If the list of ingest pipelines is not available
  // gracefully defaults to text input
  ingestPipelineNames.length > 0 || isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: ingestPipelineLabel,
    isInvalid: errorMessages.length > 0,
    error: errorMessages
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    width: "100%",
    height: euiTheme.size.xxl,
    isLoading: isLoading,
    contentAriaLabel: ingestPipelineLabel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "transformEditFlyoutDestinationIngestPipelineFieldSelect",
    "aria-label": _i18n.i18n.translate('xpack.transform.stepDetailsForm.editFlyoutFormDestinationIngestPipelineFieldSelectAriaLabel', {
      defaultMessage: 'Select an ingest pipeline'
    }),
    placeholder: _i18n.i18n.translate('xpack.transform.stepDetailsForm.editFlyoutFormDestinationIngestPipelineFieldSelectPlaceholder', {
      defaultMessage: 'Select an ingest pipeline'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: ingestPipelineNames.map(label => ({
      label
    })),
    selectedOptions: [{
      label: value
    }],
    onChange: o => {
      var _o$0$label, _o$;
      return formField({
        field: 'destinationIngestPipeline',
        value: (_o$0$label = (_o$ = o[0]) === null || _o$ === void 0 ? void 0 : _o$.label) !== null && _o$0$label !== void 0 ? _o$0$label : ''
      });
    }
  }))) : /*#__PURE__*/_react.default.createElement(_edit_transform_flyout_form_text_input.EditTransformFlyoutFormTextInput, {
    field: "destinationIngestPipeline",
    label: ingestPipelineLabel
  }));
};
exports.EditTransformIngestPipeline = EditTransformIngestPipeline;