"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateAlertRuleAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _authorization = require("../../../../lib/authorization");
var _create_alert_rule_action_name = require("./create_alert_rule_action_name");
var _transform_alerting_flyout = require("../../../../../alerting/transform_alerting_flyout");
var _transform = require("../../../../../../common/types/transform");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreateAlertRuleAction = forceDisable => {
  const {
    canCreateTransformAlerts
  } = (0, _react.useContext)(_authorization.AuthorizationContext).capabilities;
  const {
    setCreateAlertRule
  } = (0, _transform_alerting_flyout.useAlertRuleFlyout)();
  const clickHandler = (0, _react.useCallback)(item => {
    setCreateAlertRule(item.id);
  }, [setCreateAlertRule]);
  const action = (0, _react.useMemo)(() => ({
    name: item => /*#__PURE__*/_react.default.createElement(_create_alert_rule_action_name.CreateAlertRuleActionName, {
      disabled: !canCreateTransformAlerts
    }),
    available: item => (0, _transform.isContinuousTransform)(item.config),
    enabled: () => canCreateTransformAlerts && !forceDisable,
    description: _create_alert_rule_action_name.crateAlertRuleActionNameText,
    type: 'icon',
    icon: 'bell',
    onClick: clickHandler,
    'data-test-subj': 'transformActionCreateAlertRule'
  }), [canCreateTransformAlerts, forceDisable, clickHandler]);
  return {
    action
  };
};
exports.useCreateAlertRuleAction = useCreateAlertRuleAction;