"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cloneActionNameText = exports.CloneActionName = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _authorization = require("../../../../lib/authorization");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cloneActionNameText = _i18n.i18n.translate('xpack.transform.transformList.cloneActionNameText', {
  defaultMessage: 'Clone'
});
exports.cloneActionNameText = cloneActionNameText;
const CloneActionName = ({
  disabled
}) => {
  if (disabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: (0, _authorization.createCapabilityFailureMessage)('canStartStopTransform')
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, cloneActionNameText));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, cloneActionNameText);
};
exports.CloneActionName = CloneActionName;