"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateTransformSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _use_documentation_links = require("../../hooks/use_documentation_links");
var _use_search_items = require("../../hooks/use_search_items");
var _navigation = require("../../services/navigation");
var _authorization = require("../../lib/authorization");
var _wizard = require("./components/wizard");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateTransformSection = ({
  match
}) => {
  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    _navigation.breadcrumbService.setBreadcrumbs(_navigation.BREADCRUMB_SECTION.CREATE_TRANSFORM);
    _navigation.docTitleService.setTitle('createTransform');
  }, []);
  const {
    esTransform
  } = (0, _use_documentation_links.useDocumentationLinks)();
  const {
    error: searchItemsError,
    searchItems
  } = (0, _use_search_items.useSearchItems)(match.params.savedObjectId);
  const docsLink = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: esTransform,
    target: "_blank",
    iconType: "help",
    "data-test-subj": "documentationLink"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.transformsWizard.transformDocsLinkText",
    defaultMessage: "Transform docs"
  }));
  return /*#__PURE__*/_react.default.createElement(_authorization.PrivilegesWrapper, {
    privileges: _constants.APP_CREATE_TRANSFORM_CLUSTER_PRIVILEGES
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.transformsWizard.createTransformTitle",
      defaultMessage: "Create transform"
    }),
    rightSideItems: [docsLink],
    bottomBorder: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageContentBody_Deprecated, {
    "data-test-subj": "transformPageCreateTransform"
  }, searchItemsError !== undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: searchItemsError,
    color: "danger",
    iconType: "warning"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), searchItems !== undefined && /*#__PURE__*/_react.default.createElement(_wizard.Wizard, {
    searchItems: searchItems
  })));
};
exports.CreateTransformSection = CreateTransformSection;