"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKibanaFieldTypeFromEsType = getKibanaFieldTypeFromEsType;
exports.getPivotDropdownOptions = getPivotDropdownOptions;
var _fieldTypes = require("@kbn/field-types");
var _mlAggUtils = require("@kbn/ml-agg-utils");
var _mlRuntimeFieldUtils = require("@kbn/ml-runtime-field-utils");
var _mlNestedProperty = require("@kbn/ml-nested-property");
var _field_utils = require("../../../../../../../common/utils/field_utils");
var _common = require("../../../../../common");
var _get_default_aggregation_config = require("./get_default_aggregation_config");
var _get_default_group_by_config = require("./get_default_group_by_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const illegalEsAggNameChars = /[[\]>]/g;
function getKibanaFieldTypeFromEsType(type) {
  switch (type) {
    case _fieldTypes.ES_FIELD_TYPES.FLOAT:
    case _fieldTypes.ES_FIELD_TYPES.HALF_FLOAT:
    case _fieldTypes.ES_FIELD_TYPES.SCALED_FLOAT:
    case _fieldTypes.ES_FIELD_TYPES.DOUBLE:
    case _fieldTypes.ES_FIELD_TYPES.INTEGER:
    case _fieldTypes.ES_FIELD_TYPES.LONG:
    case _fieldTypes.ES_FIELD_TYPES.SHORT:
    case _fieldTypes.ES_FIELD_TYPES.UNSIGNED_LONG:
      return _fieldTypes.KBN_FIELD_TYPES.NUMBER;
    case _fieldTypes.ES_FIELD_TYPES.DATE:
    case _fieldTypes.ES_FIELD_TYPES.DATE_NANOS:
      return _fieldTypes.KBN_FIELD_TYPES.DATE;
    case _fieldTypes.ES_FIELD_TYPES.KEYWORD:
    case _fieldTypes.ES_FIELD_TYPES.STRING:
      return _fieldTypes.KBN_FIELD_TYPES.STRING;
    default:
      return type;
  }
}
function getPivotDropdownOptions(dataView, runtimeMappings) {
  // The available group by options
  const groupByOptions = [];
  const groupByOptionsData = {};

  // The available aggregations
  const aggOptions = [];
  const aggOptionsData = {};
  const ignoreFieldNames = ['_id', '_index', '_type'];
  const dataViewFields = dataView.fields.filter(field => field.aggregatable === true && !ignoreFieldNames.includes(field.name) && !field.runtimeField &&
  // runtime fix, we experienced Kibana index patterns with `undefined` type for fields
  // even when the TS interface is a non-optional `string`.
  typeof field.type !== 'undefined').map(field => ({
    name: field.name,
    type: (0, _mlAggUtils.isCounterTimeSeriesMetric)(field) ? _mlAggUtils.TIME_SERIES_METRIC_TYPES.COUNTER : field.type
  }));

  // Support for runtime_mappings that are defined by queries
  let runtimeFields = [];
  if ((0, _mlRuntimeFieldUtils.isRuntimeMappings)(runtimeMappings)) {
    runtimeFields = Object.keys(runtimeMappings).map(fieldName => {
      const field = runtimeMappings[fieldName];
      return {
        name: fieldName,
        type: getKibanaFieldTypeFromEsType(field.type)
      };
    });
  }
  const sortByLabel = (a, b) => a.name.localeCompare(b.name);
  const combinedFields = [...dataViewFields, ...runtimeFields].sort(sortByLabel);
  combinedFields.forEach(field => {
    const rawFieldName = field.name;
    const displayFieldName = (0, _field_utils.removeKeywordPostfix)(rawFieldName);

    // Group by
    const availableGroupByAggs = (0, _mlNestedProperty.getNestedProperty)(_common.pivotGroupByFieldSupport, field.type);
    if (availableGroupByAggs !== undefined) {
      availableGroupByAggs.forEach(groupByAgg => {
        // Aggregation name for the group-by is the plain field name. Illegal characters will be removed.
        const aggName = displayFieldName.replace(illegalEsAggNameChars, '').trim();
        // Option name in the dropdown for the group-by is in the form of `sum(fieldname)`.
        const dropDownName = `${groupByAgg}(${displayFieldName})`;
        const groupByOption = {
          label: dropDownName,
          field: {
            id: rawFieldName,
            type: field.type
          }
        };
        groupByOptions.push(groupByOption);
        groupByOptionsData[dropDownName] = (0, _get_default_group_by_config.getDefaultGroupByConfig)(aggName, dropDownName, rawFieldName, groupByAgg);
      });
    }

    // Aggregations
    const aggOption = {
      label: displayFieldName,
      options: [],
      field: {
        id: rawFieldName,
        type: field.type
      }
    };
    const availableAggs = (0, _mlNestedProperty.getNestedProperty)(_common.pivotAggsFieldSupport, field.type);
    if (availableAggs !== undefined) {
      availableAggs.forEach(agg => {
        // Aggregation name is formatted like `fieldname.sum`. Illegal characters will be removed.
        const aggName = `${displayFieldName.replace(illegalEsAggNameChars, '').trim()}.${agg}`;
        // Option name in the dropdown for the aggregation is in the form of `sum(fieldname)`.
        const dropDownName = `${agg}(${displayFieldName})`;
        aggOption.options.push({
          label: dropDownName
        });
        aggOptionsData[dropDownName] = (0, _get_default_aggregation_config.getDefaultAggregationConfig)(aggName, dropDownName, rawFieldName, agg);
      });
    }
    aggOptions.push(aggOption);
  });
  return {
    fields: combinedFields,
    groupByOptions,
    groupByOptionsData,
    aggOptions,
    aggOptionsData
  };
}