"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataSearch = void 0;
var _react = require("react");
var _rxjs = require("rxjs");
var _app_dependencies = require("../app_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDataSearch = () => {
  const {
    data
  } = (0, _app_dependencies.useAppDependencies)();
  return (0, _react.useCallback)(async (esSearchRequestParams, abortSignal) => {
    try {
      const {
        rawResponse: resp
      } = await (0, _rxjs.lastValueFrom)(data.search.search({
        params: esSearchRequestParams
      }, {
        abortSignal
      }));
      return resp;
    } catch (error) {
      if (error.name === 'AbortError') {
        // ignore abort errors
      } else {
        return error;
      }
    }
  }, [data]);
};
exports.useDataSearch = useDataSearch;