"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_flyout_context = require("../../hooks/use_flyout_context");
var _take_action = require("./take_action");
var _date_formatter = require("../../../../components/date_formatter");
var _indicator = require("../../../../../common/types/indicator");
var _json_tab = require("./json_tab");
var _table_tab = require("./table_tab");
var _unwrap_value = require("../../utils/unwrap_value");
var _overview_tab = require("./overview_tab");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var TAB_IDS;
(function (TAB_IDS) {
  TAB_IDS[TAB_IDS["overview"] = 0] = "overview";
  TAB_IDS[TAB_IDS["table"] = 1] = "table";
  TAB_IDS[TAB_IDS["json"] = 2] = "json";
})(TAB_IDS || (TAB_IDS = {}));
/**
 * Leverages the {@link EuiFlyout} from the @elastic/eui library to dhow the details of a specific {@link Indicator}.
 */
const IndicatorsFlyout = ({
  indicator,
  closeFlyout,
  kqlBarIntegration = false,
  indicatorName
}) => {
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(TAB_IDS.overview);
  const tabs = (0, _react.useMemo)(() => [{
    id: TAB_IDS.overview,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.threatIntelligence.indicator.flyout.overviewTabLabel",
      defaultMessage: "Overview"
    }),
    content: /*#__PURE__*/_react.default.createElement(_overview_tab.IndicatorsFlyoutOverview, {
      indicator: indicator,
      onViewAllFieldsInTable: () => setSelectedTabId(TAB_IDS.table)
    })
  }, {
    id: TAB_IDS.table,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.threatIntelligence.indicator.flyout.tableTabLabel",
      defaultMessage: "Table"
    }),
    content: /*#__PURE__*/_react.default.createElement(_table_tab.IndicatorsFlyoutTable, {
      indicator: indicator
    })
  }, {
    id: TAB_IDS.json,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.threatIntelligence.indicator.flyout.jsonTabLabel",
      defaultMessage: "JSON"
    }),
    content: /*#__PURE__*/_react.default.createElement(_json_tab.IndicatorsFlyoutJson, {
      indicator: indicator
    })
  }], [indicator]);
  const onSelectedTabChanged = id => setSelectedTabId(id);
  const renderTabs = tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => onSelectedTabChanged(tab.id),
    isSelected: tab.id === selectedTabId,
    key: index
  }, tab.name));
  const selectedTabContent = (0, _react.useMemo)(() => {
    var _tabs$find;
    return (_tabs$find = tabs.find(obj => obj.id === selectedTabId)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content;
  }, [selectedTabId, tabs]);
  const firstSeen = (0, _unwrap_value.unwrapValue)(indicator, _indicator.RawIndicatorFieldId.FirstSeen);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'simpleFlyoutTitle'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout,
    "aria-labelledby": flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": _test_ids.INDICATORS_FLYOUT_TITLE_TEST_ID,
    id: flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.threatIntelligence.indicator.flyout.panelTitleWithOverviewTab",
    defaultMessage: "Indicator details"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs'
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": _test_ids.INDICATORS_FLYOUT_SUBTITLE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.threatIntelligence.indicator.flyout.panelSubTitle",
    defaultMessage: "First seen: "
  }), /*#__PURE__*/_react.default.createElement(_date_formatter.DateFormatter, {
    date: firstSeen
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    "data-test-subj": _test_ids.INDICATORS_FLYOUT_TABS_TEST_ID,
    style: {
      marginBottom: '-25px'
    }
  }, renderTabs)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_use_flyout_context.IndicatorsFlyoutContext.Provider, {
    value: {
      kqlBarIntegration,
      indicatorName
    }
  }, selectedTabContent)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_take_action.TakeAction, {
    indicator: indicator
  })))));
};
exports.IndicatorsFlyout = IndicatorsFlyout;