"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptInStatusNoticeBanner = void 0;
var React = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _opt_in_message = require("./opt_in_message");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/* eslint @elastic/eui/href-or-on-click:0 */

const OptInStatusNoticeBanner = ({
  onSeenBanner,
  http,
  telemetryConstants,
  telemetryService
}) => {
  const addBasePath = http.basePath.prepend;
  const bannerTitle = _i18n.i18n.translate('telemetry.telemetryOptedInNoticeTitle', {
    defaultMessage: 'Help us improve the Elastic Stack'
  });
  return /*#__PURE__*/React.createElement(_eui.EuiCallOut, {
    title: bannerTitle
  }, /*#__PURE__*/React.createElement(_opt_in_message.OptInMessage, {
    telemetryConstants: telemetryConstants,
    telemetryService: telemetryService,
    addBasePath: addBasePath,
    onClick: onSeenBanner
  }), /*#__PURE__*/React.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(_eui.EuiButton, {
    size: "s",
    onClick: onSeenBanner
  }, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
    id: "telemetry.telemetryOptedInDismissMessage",
    defaultMessage: "Dismiss"
  })));
};
exports.OptInStatusNoticeBanner = OptInStatusNoticeBanner;