"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.secondsToCronFormatter = exports.replaceStringWithParams = exports.hasNoParams = void 0;
var _lightweight_param_formatter = require("./lightweight_param_formatter");
var _variable_parser = _interopRequireDefault(require("./variable_parser"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const replaceStringWithParams = (value, params, logger) => {
  if (!value || typeof value === 'boolean') {
    return value;
  }
  try {
    if (typeof value !== 'string') {
      const strValue = JSON.stringify(value);
      if (hasNoParams(strValue)) {
        return value;
      }
      const parsedVars = _variable_parser.default.parse(strValue);
      const parseValue = (0, _lightweight_param_formatter.replaceVarsWithParams)(parsedVars, params);
      return JSON.parse(parseValue);
    }
    if (hasNoParams(value)) {
      return value;
    }
    const parsedVars = _variable_parser.default.parse(value);
    return (0, _lightweight_param_formatter.replaceVarsWithParams)(parsedVars, params);
  } catch (e) {
    logger === null || logger === void 0 ? void 0 : logger.error(`error parsing vars for value ${JSON.stringify(value)}, ${e}`);
  }
  return value;
};
exports.replaceStringWithParams = replaceStringWithParams;
const hasNoParams = strVal => {
  const shellParamsRegex = /\$\{[a-zA-Z_][a-zA-Z0-9_]*\}/g;
  return strVal.match(shellParamsRegex) === null;
};
exports.hasNoParams = hasNoParams;
const secondsToCronFormatter = (fields, key) => {
  var _ref;
  const value = (_ref = fields[key]) !== null && _ref !== void 0 ? _ref : '';
  return value ? `${value}s` : null;
};
exports.secondsToCronFormatter = secondsToCronFormatter;