"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPrivateLocationsRoute = exports.getAllPrivateLocations = void 0;
var _constants = require("../../../../common/constants");
var _private_locations = require("../../../../common/saved_objects/private_locations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPrivateLocationsRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.PRIVATE_LOCATIONS,
  validate: {},
  handler: async ({
    savedObjectsClient
  }) => {
    return await getAllPrivateLocations(savedObjectsClient);
  }
});
exports.getPrivateLocationsRoute = getPrivateLocationsRoute;
const getAllPrivateLocations = async savedObjectsClient => {
  try {
    var _obj$attributes;
    const obj = await savedObjectsClient.get(_private_locations.privateLocationsSavedObjectName, _private_locations.privateLocationsSavedObjectId);
    return (_obj$attributes = obj === null || obj === void 0 ? void 0 : obj.attributes) !== null && _obj$attributes !== void 0 ? _obj$attributes : {
      locations: []
    };
  } catch (getErr) {
    return {
      locations: []
    };
  }
};
exports.getAllPrivateLocations = getAllPrivateLocations;