"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsParamsRoute = void 0;
var _common = require("@kbn/spaces-plugin/common");
var _saved_objects = require("../../../common/types/saved_objects");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSyntheticsParamsRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.PARAMS,
  validate: {},
  handler: async ({
    savedObjectsClient,
    request,
    response,
    server
  }) => {
    try {
      var _await$server$spaces$, _server$spaces, _await$server$coreSta, _server$coreStart;
      const encryptedSavedObjectsClient = server.encryptedSavedObjects.getClient();
      const {
        id: spaceId
      } = (_await$server$spaces$ = await ((_server$spaces = server.spaces) === null || _server$spaces === void 0 ? void 0 : _server$spaces.spacesService.getActiveSpace(request))) !== null && _await$server$spaces$ !== void 0 ? _await$server$spaces$ : {
        id: _common.DEFAULT_SPACE_ID
      };
      const canSave = (_await$server$coreSta = (await ((_server$coreStart = server.coreStart) === null || _server$coreStart === void 0 ? void 0 : _server$coreStart.capabilities.resolveCapabilities(request))).uptime.save) !== null && _await$server$coreSta !== void 0 ? _await$server$coreSta : false;
      if (canSave) {
        const finder = await encryptedSavedObjectsClient.createPointInTimeFinderDecryptedAsInternalUser({
          type: _saved_objects.syntheticsParamType,
          perPage: 1000,
          namespaces: [spaceId]
        });
        const hits = [];
        for await (const result of finder.find()) {
          hits.push(...result.saved_objects);
        }
        return {
          data: hits
        };
      } else {
        const data = await savedObjectsClient.find({
          type: _saved_objects.syntheticsParamType,
          perPage: 10000
        });
        return {
          data: data.saved_objects
        };
      }
    } catch (error) {
      var _error$output;
      if (((_error$output = error.output) === null || _error$output === void 0 ? void 0 : _error$output.statusCode) === 404) {
        var _server$spaces$spaces, _server$spaces2;
        const spaceId = (_server$spaces$spaces = (_server$spaces2 = server.spaces) === null || _server$spaces2 === void 0 ? void 0 : _server$spaces2.spacesService.getSpaceId(request)) !== null && _server$spaces$spaces !== void 0 ? _server$spaces$spaces : _common.DEFAULT_SPACE_ID;
        return response.notFound({
          body: {
            message: `Kibana space '${spaceId}' does not exist`
          }
        });
      }
      throw error;
    }
  }
});
exports.getSyntheticsParamsRoute = getSyntheticsParamsRoute;