"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syntheticsAppStreamingApiRoutes = exports.syntheticsAppRestApiRoutes = void 0;
var _get_certificates = require("./certs/get_certificates");
var _get_agent_policies = require("./settings/private_locations/get_agent_policies");
var _inspect_monitor = require("./monitor_cruds/inspect_monitor");
var _delete_integration = require("./monitor_cruds/delete_integration");
var _journey_screenshots = require("./pings/journey_screenshots");
var _journey_screenshot_blocks = require("./pings/journey_screenshot_blocks");
var _last_successful_check = require("./pings/last_successful_check");
var _journeys = require("./pings/journeys");
var _update_default_alert = require("./default_alerts/update_default_alert");
var _sync_global_params = require("./settings/sync_global_params");
var _edit_param = require("./settings/edit_param");
var _params = require("./settings/params");
var _settings = require("./settings/settings");
var _get_api_key = require("./monitor_cruds/get_api_key");
var _get_service_locations = require("./synthetics_service/get_service_locations");
var _delete_monitor = require("./monitor_cruds/delete_monitor");
var _enablement = require("./synthetics_service/enablement");
var _get_monitor = require("./monitor_cruds/get_monitor");
var _delete_monitor_project = require("./monitor_cruds/delete_monitor_project");
var _get_monitor_project = require("./monitor_cruds/get_monitor_project");
var _run_once_monitor = require("./synthetics_service/run_once_monitor");
var _get_service_allowed = require("./synthetics_service/get_service_allowed");
var _test_now_monitor = require("./synthetics_service/test_now_monitor");
var _install_index_templates = require("./synthetics_service/install_index_templates");
var _edit_monitor = require("./monitor_cruds/edit_monitor");
var _add_monitor = require("./monitor_cruds/add_monitor");
var _add_monitor_project = require("./monitor_cruds/add_monitor_project");
var _add_monitor_project_legacy = require("./monitor_cruds/add_monitor_project_legacy");
var _pings = require("./pings");
var _overview_status = require("./overview_status/overview_status");
var _get_has_integration_monitors = require("./fleet/get_has_integration_monitors");
var _add_param = require("./settings/add_param");
var _delete_param = require("./settings/delete_param");
var _enable_default_alert = require("./default_alerts/enable_default_alert");
var _get_default_alert = require("./default_alerts/get_default_alert");
var _network_events = require("./network_events");
var _add_private_location = require("./settings/private_locations/add_private_location");
var _delete_private_location = require("./settings/private_locations/delete_private_location");
var _get_private_locations = require("./settings/private_locations/get_private_locations");
var _filters = require("./filters/filters");
var _get_monitors_list = require("./monitor_cruds/get_monitors_list");
var _get_location_monitors = require("./settings/private_locations/get_location_monitors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const syntheticsAppRestApiRoutes = [_add_monitor.addSyntheticsMonitorRoute, _add_monitor_project.addSyntheticsProjectMonitorRoute, _enablement.getSyntheticsEnablementRoute, _delete_monitor.deleteSyntheticsMonitorRoute, _delete_monitor_project.deleteSyntheticsMonitorProjectRoute, _enablement.disableSyntheticsRoute, _edit_monitor.editSyntheticsMonitorRoute, _get_service_locations.getServiceLocationsRoute, _get_monitor.getSyntheticsMonitorRoute, _get_monitor_project.getSyntheticsProjectMonitorsRoute, _get_monitors_list.getAllSyntheticsMonitorRoute, _get_monitor.getSyntheticsMonitorOverviewRoute, _install_index_templates.installIndexTemplatesRoute, _run_once_monitor.runOnceSyntheticsMonitorRoute, _test_now_monitor.testNowMonitorRoute, _get_service_allowed.getServiceAllowedRoute, _get_api_key.getAPIKeySyntheticsRoute, _pings.syntheticsGetPingsRoute, _pings.syntheticsGetPingStatusesRoute, _get_has_integration_monitors.getHasIntegrationMonitorsRoute, _overview_status.createGetCurrentStatusRoute, _settings.getIndexSizesRoute, _params.getSyntheticsParamsRoute, _edit_param.editSyntheticsParamsRoute, _add_param.addSyntheticsParamsRoute, _delete_param.deleteSyntheticsParamsRoute, _sync_global_params.syncParamsSyntheticsParamsRoute, _enable_default_alert.enableDefaultAlertingRoute, _get_default_alert.getDefaultAlertingRoute, _update_default_alert.updateDefaultAlertingRoute, _journeys.createJourneyRoute, _last_successful_check.createLastSuccessfulCheckRoute, _journey_screenshot_blocks.createJourneyScreenshotBlocksRoute, _journeys.createJourneyFailedStepsRoute, _network_events.createNetworkEventsRoute, _journey_screenshots.createJourneyScreenshotRoute, _delete_integration.deletePackagePolicyRoute, _add_private_location.addPrivateLocationRoute, _delete_private_location.deletePrivateLocationRoute, _get_location_monitors.getLocationMonitors, _get_private_locations.getPrivateLocationsRoute, _filters.getSyntheticsFilters, _inspect_monitor.inspectSyntheticsMonitorRoute, _get_agent_policies.getAgentPoliciesRoute, _get_certificates.getSyntheticsCertsRoute];
exports.syntheticsAppRestApiRoutes = syntheticsAppRestApiRoutes;
const syntheticsAppStreamingApiRoutes = [_add_monitor_project_legacy.addSyntheticsProjectMonitorRouteLegacy];
exports.syntheticsAppStreamingApiRoutes = syntheticsAppStreamingApiRoutes;