"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setTLSRecoveredAlertsContext = exports.getCertSummary = void 0;
var _moment = _interopRequireDefault(require("moment/moment"));
var _common = require("@kbn/observability-plugin/common");
var _i18n = require("@kbn/i18n");
var _action_variables = require("../action_variables");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getValidBefore = notBefore => {
  if (!notBefore) return {
    summary: 'Error, missing `certificate_not_valid_before` date.'
  };
  const relativeDate = (0, _moment.default)().diff(notBefore, 'days');
  const formattedDate = (0, _moment.default)(notBefore).format('MMM D, YYYY z');
  return relativeDate >= 0 ? {
    summary: _translations.tlsTranslations.validBeforeExpiredString(formattedDate, relativeDate),
    status: _translations.tlsTranslations.agingLabel
  } : {
    summary: _translations.tlsTranslations.validBeforeExpiringString(formattedDate, Math.abs(relativeDate)),
    status: _translations.tlsTranslations.invalidLabel
  };
};
const getValidAfter = notAfter => {
  if (!notAfter) return {
    summary: 'Error, missing `certificate_not_valid_after` date.'
  };
  const relativeDate = (0, _moment.default)().diff(notAfter, 'days');
  const formattedDate = (0, _moment.default)(notAfter).format('MMM D, YYYY z');
  return relativeDate >= 0 ? {
    summary: _translations.tlsTranslations.validAfterExpiredString(formattedDate, relativeDate),
    status: _translations.tlsTranslations.expiredLabel
  } : {
    summary: _translations.tlsTranslations.validAfterExpiringString(formattedDate, Math.abs(relativeDate)),
    status: _translations.tlsTranslations.expiringLabel
  };
};
const getCertSummary = (cert, expirationThreshold, ageThreshold) => {
  var _cert$not_after, _cert$not_before, _cert$sha, _cert$common_name, _cert$issuer;
  const isExpiring = new Date((_cert$not_after = cert.not_after) !== null && _cert$not_after !== void 0 ? _cert$not_after : '').valueOf() < expirationThreshold;
  const isAging = new Date((_cert$not_before = cert.not_before) !== null && _cert$not_before !== void 0 ? _cert$not_before : '').valueOf() < ageThreshold;
  let content = null;
  if (isExpiring) {
    content = getValidAfter(cert.not_after);
  } else if (isAging) {
    content = getValidBefore(cert.not_before);
  }
  const {
    summary = '',
    status = ''
  } = content || {};
  return {
    summary,
    status,
    sha256: (_cert$sha = cert.sha256) !== null && _cert$sha !== void 0 ? _cert$sha : '',
    commonName: (_cert$common_name = cert.common_name) !== null && _cert$common_name !== void 0 ? _cert$common_name : '',
    issuer: (_cert$issuer = cert.issuer) !== null && _cert$issuer !== void 0 ? _cert$issuer : '',
    monitorName: cert.monitorName,
    monitorType: cert.monitorType,
    locationName: cert.locationName,
    monitorUrl: cert.monitorUrl,
    configId: cert.configId
  };
};
exports.getCertSummary = getCertSummary;
const setTLSRecoveredAlertsContext = async ({
  alertFactory,
  basePath,
  defaultStartedAt,
  getAlertStartedDate,
  spaceId,
  alertsLocator,
  getAlertUuid,
  latestPings
}) => {
  const {
    getRecoveredAlerts
  } = alertFactory.done();
  for await (const alert of getRecoveredAlerts()) {
    var _getAlertStartedDate, _latestPing$tls$serve, _latestPing$tls, _latestPing$tls$serve2, _latestPing$tls$serve3, _latestPing$tls$serve4, _latestPing$tls2, _latestPing$tls2$serv, _latestPing$tls2$serv2, _latestPing$tls3, _latestPing$tls3$serv, _latestPing$tls3$serv2, _latestPing$tls4, _latestPing$tls4$serv, _latestPing$tls4$serv2;
    const recoveredAlertId = alert.getId();
    const alertUuid = (getAlertUuid === null || getAlertUuid === void 0 ? void 0 : getAlertUuid(recoveredAlertId)) || null;
    const indexedStartedAt = (_getAlertStartedDate = getAlertStartedDate(recoveredAlertId)) !== null && _getAlertStartedDate !== void 0 ? _getAlertStartedDate : defaultStartedAt;
    const state = alert.getState();
    const alertUrl = await (0, _common.getAlertUrl)(alertUuid, spaceId, indexedStartedAt, alertsLocator, basePath.publicBaseUrl);
    const configId = state.configId;
    const latestPing = latestPings.find(ping => ping.config_id === configId);
    const previousStatus = _i18n.i18n.translate('xpack.synthetics.alerts.tls.previousStatus', {
      defaultMessage: 'Certificate {commonName} {summary}',
      values: {
        commonName: state.commonName,
        summary: state.summary
      }
    });
    const newCommonName = (_latestPing$tls$serve = latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$tls = latestPing.tls) === null || _latestPing$tls === void 0 ? void 0 : (_latestPing$tls$serve2 = _latestPing$tls.server) === null || _latestPing$tls$serve2 === void 0 ? void 0 : (_latestPing$tls$serve3 = _latestPing$tls$serve2.x509) === null || _latestPing$tls$serve3 === void 0 ? void 0 : _latestPing$tls$serve3.subject.common_name) !== null && _latestPing$tls$serve !== void 0 ? _latestPing$tls$serve : '';
    const newExpiryDate = (_latestPing$tls$serve4 = latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$tls2 = latestPing.tls) === null || _latestPing$tls2 === void 0 ? void 0 : (_latestPing$tls2$serv = _latestPing$tls2.server) === null || _latestPing$tls2$serv === void 0 ? void 0 : (_latestPing$tls2$serv2 = _latestPing$tls2$serv.x509) === null || _latestPing$tls2$serv2 === void 0 ? void 0 : _latestPing$tls2$serv2.not_after) !== null && _latestPing$tls$serve4 !== void 0 ? _latestPing$tls$serve4 : '';
    const {
      summary
    } = getValidAfter(newExpiryDate);
    let newStatus = _i18n.i18n.translate('xpack.synthetics.alerts.tls.newStatus', {
      defaultMessage: 'Certificate {commonName} {summary}',
      values: {
        commonName: newCommonName,
        summary
      }
    });
    let newSummary = '';
    if (state.sha256 !== (latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$tls3 = latestPing.tls) === null || _latestPing$tls3 === void 0 ? void 0 : (_latestPing$tls3$serv = _latestPing$tls3.server) === null || _latestPing$tls3$serv === void 0 ? void 0 : (_latestPing$tls3$serv2 = _latestPing$tls3$serv.hash) === null || _latestPing$tls3$serv2 === void 0 ? void 0 : _latestPing$tls3$serv2.sha256)) {
      newSummary = _i18n.i18n.translate('xpack.synthetics.alerts.tls.newSummary', {
        defaultMessage: 'Monitor certificate has been updated.'
      });
    }
    if (state.sha256 === (latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$tls4 = latestPing.tls) === null || _latestPing$tls4 === void 0 ? void 0 : (_latestPing$tls4$serv = _latestPing$tls4.server) === null || _latestPing$tls4$serv === void 0 ? void 0 : (_latestPing$tls4$serv2 = _latestPing$tls4$serv.hash) === null || _latestPing$tls4$serv2 === void 0 ? void 0 : _latestPing$tls4$serv2.sha256) || !latestPing) {
      // in this case it seems like threshold has been changed, but the cert is the same
      newSummary = _i18n.i18n.translate('xpack.synthetics.alerts.tls.newSummaryThreshold', {
        defaultMessage: 'Expiry/Age threshold has been updated.'
      });
      newStatus = previousStatus;
    }
    alert.setContext({
      ...state,
      newStatus,
      previousStatus,
      summary: newSummary,
      [_action_variables.ALERT_DETAILS_URL]: alertUrl
    });
  }
};
exports.setTLSRecoveredAlertsContext = setTLSRecoveredAlertsContext;