"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchIndexStatus = void 0;
var _constants = require("../../../../common/constants");
var _runtime_types = require("../../../../common/runtime_types");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let indexStatusPromise = null;
const fetchIndexStatus = async (from, to) => {
  if (indexStatusPromise) {
    return indexStatusPromise;
  }
  indexStatusPromise = _utils.apiService.get(_constants.API_URLS.INDEX_STATUS, {
    from,
    to
  }, _runtime_types.StatesIndexStatusType);
  indexStatusPromise.then(() => {
    indexStatusPromise = null;
  }, () => {
    indexStatusPromise = null;
  });
  return indexStatusPromise;
};
exports.fetchIndexStatus = fetchIndexStatus;