"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScreenshotLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/kibana-react-plugin/common");
var _react_router_helpers = require("../../../common/react_router_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LabelLink = _common.euiStyled.div`
  margin-bottom: ${props => props.theme.eui.euiSizeXS};
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeS};
`;
const ScreenshotLink = ({
  lastSuccessfulCheck
}) => {
  var _lastSuccessfulCheck$;
  return /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.synthetics.executedStep.screenshot.successfulLink",
    defaultMessage: "Screenshot from {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_react_router_helpers.ReactRouterEuiLink, {
        to: `/journey/${lastSuccessfulCheck === null || lastSuccessfulCheck === void 0 ? void 0 : (_lastSuccessfulCheck$ = lastSuccessfulCheck.monitor) === null || _lastSuccessfulCheck$ === void 0 ? void 0 : _lastSuccessfulCheck$.check_group}/steps`,
        className: "eui-displayInlineBlock"
      }, /*#__PURE__*/_react.default.createElement(LabelLink, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.synthetics.executedStep.screenshot.success",
        defaultMessage: "last successful check"
      })))
    }
  }));
};
exports.ScreenshotLink = ScreenshotLink;