"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusFilter = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _filter_status_button = require("./filter_status_button");
var _hooks = require("../../../hooks");
var _translations = require("../../../../../common/translations/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusFilter = () => {
  const {
    statusFilter
  } = (0, _hooks.useGetUrlParams)();

  // Empty string for all filter button value, since we dont store it in url, so keeping it in sync
  const ALL = '';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_filter_status_button.FilterStatusButton, {
    content: _i18n.i18n.translate('xpack.synthetics.filterBar.filterAllLabel', {
      defaultMessage: 'All'
    }),
    dataTestSubj: "xpack.synthetics.filterBar.filterStatusAll",
    value: ALL,
    withNext: true,
    isActive: statusFilter === ''
  }), /*#__PURE__*/_react.default.createElement(_filter_status_button.FilterStatusButton, {
    content: _translations.STATUS_UP_LABEL,
    dataTestSubj: "xpack.synthetics.filterBar.filterStatusUp",
    value: "up",
    withNext: true,
    isActive: statusFilter === 'up'
  }), /*#__PURE__*/_react.default.createElement(_filter_status_button.FilterStatusButton, {
    content: _translations.STATUS_DOWN_LABEL,
    dataTestSubj: "xpack.synthetics.filterBar.filterStatusDown",
    value: "down",
    withNext: false,
    isActive: statusFilter === 'down'
  }));
};
exports.StatusFilter = StatusFilter;