"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DownNoExpressionSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _alert_expression_popover = require("../alert_expression_popover");
var labels = _interopRequireWildcard(require("../translations"));
var _alert_field_number = require("../alert_field_number");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DownNoExpressionSelect = ({
  defaultNumTimes,
  hasFilters,
  isEnabled,
  setRuleParams
}) => {
  const [numTimes, setNumTimes] = (0, _react.useState)(defaultNumTimes !== null && defaultNumTimes !== void 0 ? defaultNumTimes : 5);
  (0, _react.useEffect)(() => {
    setRuleParams('numTimes', numTimes);
  }, [numTimes, setRuleParams]);
  return /*#__PURE__*/_react.default.createElement(_alert_expression_popover.AlertExpressionPopover, {
    "aria-label": labels.OPEN_THE_POPOVER_DOWN_COUNT,
    content: /*#__PURE__*/_react.default.createElement(_alert_field_number.AlertFieldNumber, {
      "aria-label": labels.ENTER_NUMBER_OF_DOWN_COUNTS,
      "data-test-subj": "xpack.synthetics.alerts.monitorStatus.numTimesField",
      disabled: false,
      fieldValue: numTimes,
      setFieldValue: setNumTimes
    }),
    "data-test-subj": "xpack.synthetics.alerts.monitorStatus.numTimesExpression",
    description: hasFilters ? labels.MATCHING_MONITORS_DOWN : labels.ANY_MONITOR_DOWN,
    id: "ping-count",
    isEnabled: isEnabled,
    value: `${numTimes} times`
  });
};
exports.DownNoExpressionSelect = DownNoExpressionSelect;