"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LOAD_EVENT_LABEL = exports.LCP_LABEL = exports.LAYOUT_SHIFT_LABEL = exports.LAYOUT_SHIFT = exports.FIELD_SYNTHETICS_LCP = exports.FIELD_SYNTHETICS_FCP = exports.FIELD_SYNTHETICS_DOCUMENT_ONLOAD = exports.FIELD_SYNTHETICS_DCL = exports.FCP_LABEL = exports.DOCUMENT_CONTENT_LOADED_LABEL = void 0;
exports.WaterfallChartMarkers = WaterfallChartMarkers;
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _ = require("..");
var _waterfall_marker_icon = require("./waterfall_marker_icon");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIELD_SYNTHETICS_LCP = 'browser.experience.lcp.us';
exports.FIELD_SYNTHETICS_LCP = FIELD_SYNTHETICS_LCP;
const FIELD_SYNTHETICS_FCP = 'browser.experience.fcp.us';
exports.FIELD_SYNTHETICS_FCP = FIELD_SYNTHETICS_FCP;
const FIELD_SYNTHETICS_DOCUMENT_ONLOAD = 'browser.experience.load.us';
exports.FIELD_SYNTHETICS_DOCUMENT_ONLOAD = FIELD_SYNTHETICS_DOCUMENT_ONLOAD;
const FIELD_SYNTHETICS_DCL = 'browser.experience.dcl.us';
exports.FIELD_SYNTHETICS_DCL = FIELD_SYNTHETICS_DCL;
const LAYOUT_SHIFT = 'layoutShift';
exports.LAYOUT_SHIFT = LAYOUT_SHIFT;
function WaterfallChartMarkers() {
  const {
    markerItems
  } = (0, _.useWaterfallContext)();
  const theme = (0, _public.useTheme)();
  const markerItemsByOffset = (0, _react.useMemo)(() => (markerItems !== null && markerItems !== void 0 ? markerItems : []).reduce((acc, cur) => {
    var _acc$get;
    acc.set(cur.offset, [...((_acc$get = acc.get(cur.offset)) !== null && _acc$get !== void 0 ? _acc$get : []), cur]);
    return acc;
  }, new Map()), [markerItems]);
  const annotations = (0, _react.useMemo)(() => {
    return Array.from(markerItemsByOffset.entries()).map(([offset, items]) => {
      var _markersInfo$field, _markersInfo$color, _markersInfo$strokeWi;
      let uniqueIds = (items !== null && items !== void 0 ? items : []).map(({
        id
      }) => id).filter((id, index, arr) => arr.indexOf(id) === index);

      // Omit coinciding layoutShift's with other vital marks
      if (uniqueIds.length > 1) {
        uniqueIds = uniqueIds.filter(id => id !== LAYOUT_SHIFT);
      }
      const label = uniqueIds.map(id => {
        var _getMarkersInfo$label, _getMarkersInfo;
        return (_getMarkersInfo$label = (_getMarkersInfo = getMarkersInfo(id, theme)) === null || _getMarkersInfo === void 0 ? void 0 : _getMarkersInfo.label) !== null && _getMarkersInfo$label !== void 0 ? _getMarkersInfo$label : id;
      }).join(' / ');
      const id = uniqueIds[0];
      const markersInfo = getMarkersInfo(id, theme);
      return {
        id,
        offset,
        label,
        field: (_markersInfo$field = markersInfo === null || markersInfo === void 0 ? void 0 : markersInfo.field) !== null && _markersInfo$field !== void 0 ? _markersInfo$field : '',
        color: (_markersInfo$color = markersInfo === null || markersInfo === void 0 ? void 0 : markersInfo.color) !== null && _markersInfo$color !== void 0 ? _markersInfo$color : theme.eui.euiColorMediumShade,
        strokeWidth: (_markersInfo$strokeWi = markersInfo === null || markersInfo === void 0 ? void 0 : markersInfo.strokeWidth) !== null && _markersInfo$strokeWi !== void 0 ? _markersInfo$strokeWi : 1
      };
    });
  }, [markerItemsByOffset, theme]);
  if (!markerItems) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(Wrapper, null, annotations.map(({
    id,
    offset,
    label,
    field,
    color,
    strokeWidth
  }) => {
    const key = `${id}-${offset}`;
    return /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
      key: key,
      id: key,
      domainType: _charts.AnnotationDomainType.YDomain,
      dataValues: [{
        dataValue: offset,
        details: label,
        header: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfall.offsetUnit', {
          defaultMessage: '{offset} ms',
          values: {
            offset
          }
        })
      }],
      marker: /*#__PURE__*/_react.default.createElement(_waterfall_marker_icon.WaterfallMarkerIcon, {
        field: field,
        label: label
      }),
      style: {
        line: {
          strokeWidth,
          stroke: color,
          opacity: 1
        }
      }
    });
  }));
}
function getMarkersInfo(id, theme) {
  switch (id) {
    case 'domContentLoaded':
      return {
        label: DOCUMENT_CONTENT_LOADED_LABEL,
        color: theme.eui.euiColorVis0,
        field: FIELD_SYNTHETICS_DCL,
        strokeWidth: 2
      };
    case 'firstContentfulPaint':
      return {
        label: FCP_LABEL,
        color: theme.eui.euiColorVis1,
        field: FIELD_SYNTHETICS_FCP,
        strokeWidth: 2
      };
    case 'largestContentfulPaint':
      return {
        label: LCP_LABEL,
        color: theme.eui.euiColorVis2,
        field: FIELD_SYNTHETICS_LCP,
        strokeWidth: 2
      };
    case 'layoutShift':
      return {
        label: LAYOUT_SHIFT_LABEL,
        color: theme.eui.euiColorVis6,
        field: '',
        strokeWidth: 1
      };
    case 'loadEvent':
      return {
        label: LOAD_EVENT_LABEL,
        color: theme.eui.euiColorVis9,
        field: FIELD_SYNTHETICS_DOCUMENT_ONLOAD,
        strokeWidth: 2
      };
  }
  return undefined;
}
const Wrapper = _common.euiStyled.span`
  &&& {
    > .echAnnotation__icon {
      top: 8px;
    }
  }
`;
const FCP_LABEL = _i18n.i18n.translate('xpack.synthetics.synthetics.waterfall.fcpLabel', {
  defaultMessage: 'First contentful paint'
});
exports.FCP_LABEL = FCP_LABEL;
const LCP_LABEL = _i18n.i18n.translate('xpack.synthetics.synthetics.waterfall.lcpLabel', {
  defaultMessage: 'Largest contentful paint'
});
exports.LCP_LABEL = LCP_LABEL;
const LAYOUT_SHIFT_LABEL = _i18n.i18n.translate('xpack.synthetics.synthetics.waterfall.layoutShiftLabel', {
  defaultMessage: 'Layout shift'
});
exports.LAYOUT_SHIFT_LABEL = LAYOUT_SHIFT_LABEL;
const LOAD_EVENT_LABEL = _i18n.i18n.translate('xpack.synthetics.synthetics.waterfall.loadEventLabel', {
  defaultMessage: 'Load event'
});
exports.LOAD_EVENT_LABEL = LOAD_EVENT_LABEL;
const DOCUMENT_CONTENT_LOADED_LABEL = _i18n.i18n.translate('xpack.synthetics.synthetics.waterfall.domContentLabel', {
  defaultMessage: 'DOM Content Loaded'
});
exports.DOCUMENT_CONTENT_LOADED_LABEL = DOCUMENT_CONTENT_LOADED_LABEL;