"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getChunks = exports.MiddleTruncatedText = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _waterfall_tooltip_content = require("./waterfall_tooltip_content");
var _styles = require("./styles");
var _constants = require("./constants");
var _data_formatting = require("../../step_detail/waterfall/data_formatting");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OuterContainer = _common.euiStyled.span`
  position: relative;
  display: inline-flex;
  align-items: center;
  .euiToolTipAnchor {
    min-width: 0;
  }
`; // NOTE: min-width: 0 ensures flexbox and no-wrap children can co-exist

const InnerContainer = _common.euiStyled.span`
  overflow: hidden;
  display: flex;
  align-items: center;
`;
const IndexNumber = (0, _common.euiStyled)(_eui.EuiText)`
  font-family: ${props => props.theme.eui.euiCodeFontFamily};
  margin-right: ${props => props.theme.eui.euiSizeXS};
  line-height: ${_constants.FIXED_AXIS_HEIGHT}px;
  text-align: right;
  background-color: ${props => props.theme.eui.euiColorLightestShade};
`;
const FirstChunk = _common.euiStyled.span`
  text-overflow: ellipsis;
  white-space: nowrap;
  overflow: hidden;
  line-height: ${_constants.FIXED_AXIS_HEIGHT}px;
  text-align: left;
`; // safari doesn't auto align text left in some cases

const LastChunk = _common.euiStyled.span`
  flex-shrink: 0;
  line-height: ${_constants.FIXED_AXIS_HEIGHT}px;
  text-align: left;
`; // safari doesn't auto align text left in some cases

const StyledButton = (0, _common.euiStyled)(_eui.EuiButtonEmpty)`
  &&& {
    border: none;

    .euiButtonContent {
      display: inline-block;
      padding: 0;
    }
  }
`;
const SecureIcon = (0, _common.euiStyled)(_eui.EuiIcon)`
  margin-right: ${props => props.theme.eui.euiSizeXS};
`;
const getChunks = (text = '') => {
  const END_CHARS = 12;
  const chars = text.split('');
  const splitPoint = chars.length - END_CHARS > 0 ? chars.length - END_CHARS : null;
  const endChars = splitPoint ? chars.splice(splitPoint) : [];
  return {
    first: chars.join(''),
    last: endChars.join('')
  };
};

// Helper component for adding middle text truncation, e.g.
// really-really-really-long....ompressed.js
// Can be used to accomodate content in sidebar item rendering.
exports.getChunks = getChunks;
const MiddleTruncatedText = ({
  index,
  ariaLabel,
  text: fullText,
  onClick,
  setButtonRef,
  url,
  highestIndex
}) => {
  const secureHttps = fullText.startsWith('https://');
  const text = fullText.replace(/https:\/\/www.|http:\/\/www.|http:\/\/|https:\/\//, '');
  const chunks = (0, _react.useMemo)(() => {
    return getChunks(text);
  }, [text]);
  return /*#__PURE__*/_react.default.createElement(OuterContainer, {
    "aria-label": ariaLabel,
    "data-test-subj": "middleTruncatedTextContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "middleTruncatedTextSROnly"
  }, fullText)), /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartTooltip, {
    as: _eui.EuiToolTip,
    content: /*#__PURE__*/_react.default.createElement(_waterfall_tooltip_content.WaterfallTooltipContent, {
      text: (0, _data_formatting.formatTooltipHeading)(index, fullText),
      url
    }),
    "data-test-subj": "middleTruncatedTextToolTip",
    delay: "long",
    position: "top"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, onClick ? /*#__PURE__*/_react.default.createElement(StyledButton, {
    onClick: onClick,
    "data-test-subj": `middleTruncatedTextButton${index}`,
    buttonRef: setButtonRef,
    flush: 'left'
  }, /*#__PURE__*/_react.default.createElement(InnerContainer, null, /*#__PURE__*/_react.default.createElement(IndexNumber, {
    color: "subdued",
    size: "s",
    style: {
      minWidth: String(highestIndex).length + 1 + 'ch'
    }
  }, index + '.'), secureHttps && /*#__PURE__*/_react.default.createElement(SecureIcon, {
    type: "lock",
    size: "s",
    color: "success",
    "aria-label": _i18n.i18n.translate('xpack.synthetics.waterfallChart.sidebar.url.https', {
      defaultMessage: 'https'
    })
  }), /*#__PURE__*/_react.default.createElement(FirstChunk, null, chunks.first), /*#__PURE__*/_react.default.createElement(LastChunk, null, chunks.last))) : /*#__PURE__*/_react.default.createElement(InnerContainer, {
    "aria-hidden": true
  }, /*#__PURE__*/_react.default.createElement(FirstChunk, null, index, ". ", chunks.first), /*#__PURE__*/_react.default.createElement(LastChunk, null, chunks.last)))), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsMiddleTruncatedTextLink",
    href: url,
    external: true,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.synthetics.waterfall.resource.externalLink",
    defaultMessage: "Open resource in new tab"
  }))))));
};
exports.MiddleTruncatedText = MiddleTruncatedText;