"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorStatusDetailsComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _location_availability = require("./location_availability/location_availability");
var _contexts = require("../../../contexts");
var _status_bar = require("./status_bar");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WrapFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  &&& {
    @media (max-width: 800px) {
      flex-basis: 100%;
    }
  }
`;
const MonitorStatusDetailsComponent = ({
  monitorLocations
}) => {
  const {
    refreshApp
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const [isTabActive] = (0, _react.useState)(document.visibilityState);
  const onTabActive = () => {
    if (document.visibilityState === 'visible' && isTabActive === 'hidden') {
      refreshApp();
    }
  };

  // Refreshing application state after Tab becomes active to render latest map state
  // If application renders in when tab is not in focus it gives some unexpected behaviors
  // Where map is not visible on change
  (0, _react.useEffect)(() => {
    document.addEventListener('visibilitychange', onTabActive);
    return () => {
      document.removeEventListener('visibilitychange', onTabActive);
    };

    // we want this effect to execute exactly once after the component mounts
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    wrap: true,
    responsive: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_status_bar.MonitorStatusBar, null)), /*#__PURE__*/_react.default.createElement(WrapFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_location_availability.LocationAvailability, {
    monitorLocations: monitorLocations
  }))));
};
exports.MonitorStatusDetailsComponent = MonitorStatusDetailsComponent;