"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChartTheme = void 0;
var _eui_charts_theme = require("@elastic/eui/dist/eui_charts_theme");
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useChartTheme = () => {
  const [darkMode] = (0, _public.useUiSetting$)('theme:darkMode');
  const theme = (0, _react.useMemo)(() => {
    return darkMode ? _eui_charts_theme.EUI_CHARTS_THEME_DARK.theme : _eui_charts_theme.EUI_CHARTS_THEME_LIGHT.theme;
  }, [darkMode]);
  return theme;
};
exports.useChartTheme = useChartTheme;