"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  TestRunStatus: true,
  isTestRunning: true,
  manualTestRunsReducer: true
};
exports.manualTestRunsReducer = exports.isTestRunning = exports.TestRunStatus = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _actions = require("./actions");
Object.keys(_actions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _actions[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _actions[key];
    }
  });
});
var _runtime_types = require("../../../../../common/runtime_types");
var _selectors = require("./selectors");
Object.keys(_selectors).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _selectors[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _selectors[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let TestRunStatus;
exports.TestRunStatus = TestRunStatus;
(function (TestRunStatus) {
  TestRunStatus["LOADING"] = "loading";
  TestRunStatus["IN_PROGRESS"] = "in-progress";
  TestRunStatus["COMPLETED"] = "completed";
})(TestRunStatus || (exports.TestRunStatus = TestRunStatus = {}));
const isTestRunning = testRun => (testRun === null || testRun === void 0 ? void 0 : testRun.status) === TestRunStatus.IN_PROGRESS || (testRun === null || testRun === void 0 ? void 0 : testRun.status) === TestRunStatus.LOADING;
exports.isTestRunning = isTestRunning;
const initialState = {};
const manualTestRunsReducer = (0, _toolkit.createReducer)(initialState, builder => {
  builder.addCase(String(_actions.manualTestMonitorAction.get), (state, action) => {
    state = Object.values(state).reduce((acc, curr) => {
      acc[curr.configId] = {
        ...curr,
        isTestNowFlyoutOpen: false
      };
      return acc;
    }, state);
    state[action.payload.configId] = {
      configId: action.payload.configId,
      name: action.payload.name,
      status: TestRunStatus.LOADING,
      schedule: {
        unit: _runtime_types.ScheduleUnit.MINUTES,
        number: '3'
      },
      locations: [],
      isTestNowFlyoutOpen: true
    };
  }).addCase(String(_actions.manualTestMonitorAction.success), (state, {
    payload
  }) => {
    state[payload.configId] = {
      configId: payload.configId,
      testRunId: payload.testRunId,
      status: TestRunStatus.IN_PROGRESS,
      errors: payload.errors,
      schedule: payload.schedule,
      locations: payload.locations,
      isTestNowFlyoutOpen: true,
      monitor: payload.monitor,
      name: payload.monitor.name
    };
  }).addCase(String(_actions.manualTestMonitorAction.fail), (state, action) => {
    var _fetchError$request, _action$payload$confi, _action$payload$getPa;
    const fetchError = action.payload;
    if (fetchError !== null && fetchError !== void 0 && (_fetchError$request = fetchError.request) !== null && _fetchError$request !== void 0 && _fetchError$request.url) {
      var _Object$entries$find;
      const {
        name,
        message
      } = fetchError;
      const [, errorMonitor] = (_Object$entries$find = Object.entries(state).find(([key]) => {
        var _ref;
        return (_ref = fetchError.request.url.indexOf(key) > -1) !== null && _ref !== void 0 ? _ref : false;
      })) !== null && _Object$entries$find !== void 0 ? _Object$entries$find : [];
      if (errorMonitor) {
        state[errorMonitor.configId] = {
          ...state[errorMonitor.configId],
          status: TestRunStatus.COMPLETED,
          errors: undefined,
          fetchError: {
            name,
            message
          }
        };
      }
    }
    const configId = (_action$payload$confi = action.payload.configId) !== null && _action$payload$confi !== void 0 ? _action$payload$confi : (_action$payload$getPa = action.payload.getPayload) === null || _action$payload$getPa === void 0 ? void 0 : _action$payload$getPa.configId;
    if (configId) {
      state[configId] = {
        ...state[configId],
        status: TestRunStatus.COMPLETED,
        errors: action.payload.errors,
        fetchError: undefined
      };
    }
    return state;
  }).addCase(_actions.manualTestRunUpdateAction, (state, action) => {
    const {
      testRunId,
      ...rest
    } = action.payload;
    const configId = Object.keys(state).find(key => state[key].testRunId === testRunId);
    if (configId) {
      state[configId] = {
        ...state[configId],
        ...rest
      };
    }
  }).addCase(_actions.toggleTestNowFlyoutAction, (state, action) => {
    state = Object.values(state).reduce((acc, curr) => {
      acc[curr.configId] = {
        ...curr,
        isTestNowFlyoutOpen: false
      };
      return acc;
    }, state);
    state[action.payload] = {
      ...state[action.payload],
      isTestNowFlyoutOpen: !state[action.payload].isTestNowFlyoutOpen
    };
  }).addCase(_actions.hideTestNowFlyoutAction, state => {
    state = Object.values(state).reduce((acc, curr) => {
      acc[curr.configId] = {
        ...curr,
        isTestNowFlyoutOpen: false
      };
      return acc;
    }, state);
    return state;
  }).addCase(String(_actions.clearTestNowMonitorAction), (state, action) => {
    delete state[action.payload];
  });
});
exports.manualTestRunsReducer = manualTestRunsReducer;