"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestRunErrorInfo = void 0;
var _eui = require("@elastic/eui");
var React = _interopRequireWildcard(require("react"));
var _stderr_logs = require("../../common/components/stderr_logs");
var _browser_test_results = require("../../test_now_mode/browser/browser_test_results");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TestRunErrorInfo = ({
  journeyDetails,
  hasNoSteps,
  showErrorTitle = true,
  showErrorLogs = false
}) => {
  var _journeyDetails$journ, _journeyDetails$journ2, _journeyDetails$journ3, _journeyDetails$journ4, _journeyDetails$journ5;
  const isDownMonitor = (journeyDetails === null || journeyDetails === void 0 ? void 0 : (_journeyDetails$journ = journeyDetails.journey) === null || _journeyDetails$journ === void 0 ? void 0 : (_journeyDetails$journ2 = _journeyDetails$journ.monitor) === null || _journeyDetails$journ2 === void 0 ? void 0 : _journeyDetails$journ2.status) === 'down';
  const errorMessage = journeyDetails === null || journeyDetails === void 0 ? void 0 : (_journeyDetails$journ3 = journeyDetails.journey) === null || _journeyDetails$journ3 === void 0 ? void 0 : (_journeyDetails$journ4 = _journeyDetails$journ3.error) === null || _journeyDetails$journ4 === void 0 ? void 0 : _journeyDetails$journ4.message;
  return /*#__PURE__*/React.createElement(React.Fragment, null, (hasNoSteps || isDownMonitor) && showErrorTitle && /*#__PURE__*/React.createElement(_eui.EuiCallOut, {
    "data-test-subj": "monitorTestRunErrorCallout",
    title: _browser_test_results.ERROR_RUNNING_TEST,
    color: "danger",
    iconType: "warning"
  }, /*#__PURE__*/React.createElement(_eui.EuiText, {
    color: "danger"
  }, errorMessage !== null && errorMessage !== void 0 ? errorMessage : _browser_test_results.FAILED_TO_RUN)), /*#__PURE__*/React.createElement(_eui.EuiSpacer, {
    size: "m"
  }), isDownMonitor && (showErrorLogs || hasNoSteps) && /*#__PURE__*/React.createElement(_stderr_logs.StdErrorLogs, {
    checkGroup: journeyDetails === null || journeyDetails === void 0 ? void 0 : (_journeyDetails$journ5 = journeyDetails.journey) === null || _journeyDetails$journ5 === void 0 ? void 0 : _journeyDetails$journ5.monitor.check_group,
    hideTitle: false,
    pageSize: 10
  }));
};
exports.TestRunErrorInfo = TestRunErrorInfo;