"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimpleTestResults = SimpleTestResults;
var _react = _interopRequireWildcard(require("react"));
var _use_simple_run_once_monitors = require("../hooks/use_simple_run_once_monitors");
var _test_result_header = require("../test_result_header");
var _ping_list_table = require("./ping_list/ping_list_table");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SimpleTestResults({
  testRunId,
  expectPings,
  onDone
}) {
  const [summaryDocsCache, setSummaryDocsCache] = (0, _react.useState)([]);
  const {
    summaryDocs,
    loading
  } = (0, _use_simple_run_once_monitors.useSimpleRunOnceMonitors)({
    testRunId,
    expectSummaryDocs: expectPings
  });
  (0, _react.useEffect)(() => {
    if (summaryDocs) {
      setSummaryDocsCache(prevState => {
        const prevById = prevState.reduce((acc, cur) => ({
          ...acc,
          [cur.docId]: cur
        }), {});
        return summaryDocs.map(updatedDoc => {
          var _prevById$updatedDoc$;
          return {
            ...updatedDoc,
            ...((_prevById$updatedDoc$ = prevById[updatedDoc.docId]) !== null && _prevById$updatedDoc$ !== void 0 ? _prevById$updatedDoc$ : {})
          };
        });
      });
      if (summaryDocs.length >= expectPings) {
        onDone(testRunId);
      }
    }
  }, [testRunId, expectPings, summaryDocs, onDone]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_test_result_header.TestResultHeader, {
    summaryDocs: summaryDocsCache,
    isCompleted: Boolean(summaryDocs && summaryDocs.length >= expectPings)
  }), summaryDocs && /*#__PURE__*/_react.default.createElement(_ping_list_table.PingListTable, {
    pings: summaryDocsCache,
    loading: loading
  }));
}