"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkTimingsDonut = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _data_formatting = require("../common/network_data/data_formatting");
var _use_network_timings = require("../hooks/use_network_timings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const themeOverrides = {
  chartMargins: {
    top: 0,
    bottom: 0,
    left: 0,
    right: 0
  },
  partition: {
    linkLabel: {
      maximumSection: Infinity,
      maxCount: 0
    },
    idealFontSizeJump: 1.1,
    outerSizeRatio: 0.9,
    emptySizeRatio: 0.6,
    circlePadding: 5
  }
};
const NetworkTimingsDonut = () => {
  const networkTimings = (0, _use_network_timings.useNetworkTimings)();
  const theme = (0, _public.useTheme)();
  if (!networkTimings) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, TIMINGS_BREAKDOWN))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: SUM_TIMINGS,
    position: "right"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 240
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: [themeOverrides, _charts.LIGHT_THEME !== null && _charts.LIGHT_THEME !== void 0 ? _charts.LIGHT_THEME : {}],
    showLegend: false
  }), /*#__PURE__*/_react.default.createElement(_charts.Partition, {
    id: "spec_1",
    data: networkTimings.timingsWithLabels,
    layout: _charts.PartitionLayout.sunburst,
    valueAccessor: d => d === null || d === void 0 ? void 0 : d.value,
    valueFormatter: d => (0, _data_formatting.formatMillisecond)(d, {}),
    layers: [{
      groupByRollup: d => d.label,
      nodeLabel: d => d,
      shape: {
        fillColor: (dataName, index) => {
          return theme.eui[`euiColorVis${index + 1}`];
        }
      }
    }]
  })));
};
exports.NetworkTimingsDonut = NetworkTimingsDonut;
const TIMINGS_BREAKDOWN = _i18n.i18n.translate('xpack.synthetics.stepDetailsRoute.timingsBreakdown', {
  defaultMessage: 'Timing breakdown'
});
const SUM_TIMINGS = _i18n.i18n.translate('xpack.synthetics.stepDetailsRoute.timingsBreakdown.info', {
  defaultMessage: 'Sum of all network request timings'
});