"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStepPrevMetrics = exports.SYNTHETICS_STEP_NAME = exports.SYNTHETICS_STEP_DURATION = exports.SYNTHETICS_LCP = exports.SYNTHETICS_FCP = exports.SYNTHETICS_DOCUMENT_ONLOAD = exports.SYNTHETICS_DCL = exports.SYNTHETICS_CLS = exports.MONITOR_DURATION_US = void 0;
var _reactRouterDom = require("react-router-dom");
var _use_object_metrics = require("./use_object_metrics");
var _step_metrics = require("../step_metrics/step_metrics");
var _use_step_metrics = require("./use_step_metrics");
var _use_network_timings_prev = require("./use_network_timings_prev");
var _constants = require("../../../../../../common/constants");
var _use_redux_es_search = require("../../../hooks/use_redux_es_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MONITOR_DURATION_US = 'monitor.duration.us';
exports.MONITOR_DURATION_US = MONITOR_DURATION_US;
const SYNTHETICS_CLS = 'browser.experience.cls';
exports.SYNTHETICS_CLS = SYNTHETICS_CLS;
const SYNTHETICS_LCP = 'browser.experience.lcp.us';
exports.SYNTHETICS_LCP = SYNTHETICS_LCP;
const SYNTHETICS_FCP = 'browser.experience.fcp.us';
exports.SYNTHETICS_FCP = SYNTHETICS_FCP;
const SYNTHETICS_DOCUMENT_ONLOAD = 'browser.experience.load.us';
exports.SYNTHETICS_DOCUMENT_ONLOAD = SYNTHETICS_DOCUMENT_ONLOAD;
const SYNTHETICS_DCL = 'browser.experience.dcl.us';
exports.SYNTHETICS_DCL = SYNTHETICS_DCL;
const SYNTHETICS_STEP_NAME = 'synthetics.step.name.keyword';
exports.SYNTHETICS_STEP_NAME = SYNTHETICS_STEP_NAME;
const SYNTHETICS_STEP_DURATION = 'synthetics.step.duration.us';
exports.SYNTHETICS_STEP_DURATION = SYNTHETICS_STEP_DURATION;
const useStepPrevMetrics = step => {
  var _step$monitor$check_g, _step$synthetics$step, _step$synthetics$step2, _transferData$aggrega;
  const urlParams = (0, _reactRouterDom.useParams)();
  const monitorId = urlParams.monitorId;
  const checkGroupId = (_step$monitor$check_g = step === null || step === void 0 ? void 0 : step.monitor.check_group) !== null && _step$monitor$check_g !== void 0 ? _step$monitor$check_g : urlParams.checkGroupId;
  const stepIndex = (_step$synthetics$step = step === null || step === void 0 ? void 0 : (_step$synthetics$step2 = step.synthetics.step) === null || _step$synthetics$step2 === void 0 ? void 0 : _step$synthetics$step2.index) !== null && _step$synthetics$step !== void 0 ? _step$synthetics$step : urlParams.stepIndex;
  const {
    data,
    loading
  } = (0, _use_redux_es_search.useReduxEsSearch)({
    index: _constants.SYNTHETICS_INDEX_PATTERN,
    body: {
      size: 0,
      query: {
        bool: {
          filter: [{
            terms: {
              'synthetics.type': ['step/metrics', 'step/end']
            }
          }, {
            term: {
              'synthetics.step.index': Number(stepIndex)
            }
          }, {
            term: {
              config_id: monitorId
            }
          }, {
            range: {
              '@timestamp': {
                lte: 'now',
                gte: 'now-24h/h'
              }
            }
          }]
        }
      },
      aggs: {
        testRuns: {
          terms: {
            field: 'monitor.check_group',
            size: 10000
          },
          aggs: {
            fcp: {
              sum: {
                field: SYNTHETICS_FCP
              }
            },
            lcp: {
              sum: {
                field: SYNTHETICS_LCP
              }
            },
            cls: {
              sum: {
                field: SYNTHETICS_CLS
              }
            },
            dcl: {
              sum: {
                field: SYNTHETICS_DCL
              }
            },
            stepDuration: {
              sum: {
                field: SYNTHETICS_STEP_DURATION
              }
            }
          }
        }
      }
    }
  }, [], {
    name: `previousStepMetrics/${monitorId}/${checkGroupId}/${stepIndex}`
  });
  const {
    data: transferData
  } = (0, _use_redux_es_search.useReduxEsSearch)({
    index: _constants.SYNTHETICS_INDEX_PATTERN,
    body: {
      size: 0,
      runtime_mappings: {
        'synthetics.payload.transfer_size': {
          type: 'double'
        },
        'synthetics.payload.resource_size': {
          type: 'double'
        }
      },
      query: {
        bool: {
          filter: [{
            term: {
              'synthetics.type': 'journey/network_info'
            }
          }, {
            term: {
              'synthetics.step.index': Number(stepIndex)
            }
          }, {
            term: {
              config_id: monitorId
            }
          }, {
            range: {
              '@timestamp': {
                lte: 'now',
                gte: 'now-24h/h'
              }
            }
          }]
        }
      },
      aggs: {
        testRuns: {
          terms: {
            field: 'monitor.check_group',
            size: 10000
          },
          aggs: {
            transferSize: {
              sum: {
                field: 'synthetics.payload.transfer_size'
              }
            }
          }
        }
      }
    }
  }, [], {
    name: `previousStepMetricsFromNetworkInfos/${monitorId}/${checkGroupId}/${stepIndex}`
  });
  const metrics = data === null || data === void 0 ? void 0 : data.aggregations;
  const transferSize = [];
  transferData === null || transferData === void 0 ? void 0 : (_transferData$aggrega = transferData.aggregations) === null || _transferData$aggrega === void 0 ? void 0 : _transferData$aggrega.testRuns.buckets.forEach(bucket => {
    var _bucket$transferSize$;
    transferSize.push((_bucket$transferSize$ = bucket.transferSize.value) !== null && _bucket$transferSize$ !== void 0 ? _bucket$transferSize$ : 0);
  });
  const medianTransferSize = (0, _use_network_timings_prev.median)(transferSize);
  const lcp = [];
  const fcp = [];
  const cls = [];
  const dcl = [];
  const stepDuration = [];
  metrics === null || metrics === void 0 ? void 0 : metrics.testRuns.buckets.forEach(bucket => {
    var _bucket$lcp$value, _bucket$fcp$value, _bucket$cls$value, _bucket$dcl$value, _bucket$stepDuration$;
    lcp.push((_bucket$lcp$value = bucket.lcp.value) !== null && _bucket$lcp$value !== void 0 ? _bucket$lcp$value : 0);
    fcp.push((_bucket$fcp$value = bucket.fcp.value) !== null && _bucket$fcp$value !== void 0 ? _bucket$fcp$value : 0);
    cls.push((_bucket$cls$value = bucket.cls.value) !== null && _bucket$cls$value !== void 0 ? _bucket$cls$value : 0);
    dcl.push((_bucket$dcl$value = bucket.dcl.value) !== null && _bucket$dcl$value !== void 0 ? _bucket$dcl$value : 0);
    stepDuration.push((_bucket$stepDuration$ = bucket.stepDuration.value) !== null && _bucket$stepDuration$ !== void 0 ? _bucket$stepDuration$ : 0);
  });
  const medianLcp = (0, _use_network_timings_prev.median)(lcp);
  const medianFcp = (0, _use_network_timings_prev.median)(fcp);
  const medianCls = (0, _use_network_timings_prev.median)(cls);
  const medianDcl = (0, _use_network_timings_prev.median)(dcl);
  const medianStepDuration = (0, _use_network_timings_prev.median)(stepDuration);
  return {
    loading: loading && !metrics,
    metrics: [{
      label: _use_step_metrics.STEP_DURATION_LABEL,
      value: medianStepDuration,
      formatted: (0, _step_metrics.formatMillisecond)(medianStepDuration / 1000)
    }, {
      value: medianLcp,
      label: _use_step_metrics.LCP_LABEL,
      formatted: (0, _step_metrics.formatMillisecond)(medianLcp / 1000)
    }, {
      value: medianFcp,
      label: _use_step_metrics.FCP_LABEL,
      formatted: (0, _step_metrics.formatMillisecond)(medianFcp / 1000)
    }, {
      value: medianCls,
      label: _use_step_metrics.CLS_LABEL,
      formatted: medianCls
    }, {
      value: medianDcl,
      label: _use_step_metrics.DCL_LABEL,
      formatted: (0, _step_metrics.formatMillisecond)(medianDcl / 1000)
    }, {
      value: medianTransferSize,
      label: _use_step_metrics.TRANSFER_SIZE,
      formatted: (0, _use_object_metrics.formatBytes)(medianTransferSize)
    }]
  };
};
exports.useStepPrevMetrics = useStepPrevMetrics;