"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertingDefaults = void 0;
var _public = require("@kbn/observability-shared-plugin/public");
var _reactRedux = require("react-redux");
var _react = require("react");
var _selectors = require("../../../../state/settings/selectors");
var _api = require("../../../../state/settings/api");
var _actions = require("../../../../state/settings/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAlertingDefaults = () => {
  const {
    data: actionTypes
  } = (0, _public.useFetcher)(() => (0, _api.fetchActionTypes)(), []);
  const {
    connectors,
    connectorsLoading,
    loading,
    settings
  } = (0, _reactRedux.useSelector)(_selectors.selectDynamicSettings);
  const {
    defaultConnectors
  } = settings || {};
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    dispatch(_actions.getConnectorsAction.get());
  }, [dispatch]);
  const options = (connectors !== null && connectors !== void 0 ? connectors : []).filter(action => (actionTypes !== null && actionTypes !== void 0 ? actionTypes : []).find(type => type.id === action.actionTypeId)).map(connectorAction => ({
    value: connectorAction.id,
    label: connectorAction.name,
    'data-test-subj': connectorAction.name
  }));
  return {
    options,
    actionTypes,
    connectors,
    connectorsLoading,
    settingsLoading: loading,
    defaultConnectors
  };
};
exports.useAlertingDefaults = useAlertingDefaults;