"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _public = require("@kbn/observability-shared-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _disabled_callout = require("../management/disabled_callout");
var _filter_group = require("../common/monitor_filters/filter_group");
var _overview_alerts = require("./overview/overview_alerts");
var _hooks = require("../../../hooks");
var _synthetics_refresh_context = require("../../../contexts/synthetics_refresh_context");
var _state = require("../../../state");
var _service_locations = require("../../../state/service_locations");
var _constants = require("../../../../../../common/constants");
var _use_monitor_list = require("../hooks/use_monitor_list");
var _use_breadcrumbs = require("./use_breadcrumbs");
var _overview_grid = require("./overview/overview_grid");
var _overview_status = require("./overview/overview_status");
var _quick_filters = require("./overview/quick_filters");
var _search_field = require("../common/search_field");
var _no_monitors_found = require("../common/no_monitors_found");
var _overview_errors = require("./overview/overview_errors/overview_errors");
var _alerting_callout = require("../../common/alerting_callout/alerting_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewPage = () => {
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'overview'
  });
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'overview',
    delay: 15000
  });
  (0, _use_breadcrumbs.useOverviewBreadcrumbs)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    lastRefresh
  } = (0, _synthetics_refresh_context.useSyntheticsRefreshContext)();
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    loading: locationsLoading,
    locationsLoaded
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  (0, _react.useEffect)(() => {
    if (!locationsLoading && !locationsLoaded) {
      dispatch((0, _service_locations.getServiceLocations)());
    }
  }, [dispatch, locationsLoaded, locationsLoading]);
  const {
    enablement: {
      isEnabled
    },
    loading: enablementLoading
  } = (0, _hooks.useEnablement)();
  const {
    loaded: overviewLoaded,
    data: {
      monitors
    },
    pageState
  } = (0, _reactRedux.useSelector)(_state.selectOverviewState);
  const {
    loading: monitorsLoading,
    loaded: monitorsLoaded,
    handleFilterChange,
    absoluteTotal
  } = (0, _use_monitor_list.useMonitorList)();

  // fetch overview for all other page state changes
  (0, _react.useEffect)(() => {
    if (!overviewLoaded) {
      dispatch(_state.fetchMonitorOverviewAction.get(pageState));
    }
    // change only needs to be triggered on pageState change
  }, [dispatch, pageState, overviewLoaded]);

  // fetch overview for refresh
  (0, _react.useEffect)(() => {
    if (monitorsLoaded) {
      dispatch(_state.quietFetchOverviewAction.get(pageState));
    }
    // for page state change we don't want quite fetch, see above fetch ^^
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dispatch, lastRefresh]);
  const hasNoMonitors = !search && !enablementLoading && monitorsLoaded && absoluteTotal === 0;
  if (hasNoMonitors && !monitorsLoading && isEnabled) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _constants.GETTING_STARTED_ROUTE
    });
  }
  if (!isEnabled && hasNoMonitors) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _constants.MONITORS_ROUTE
    });
  }
  const noMonitorFound = monitorsLoaded && overviewLoaded && (monitors === null || monitors === void 0 ? void 0 : monitors.length) === 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_disabled_callout.DisabledCallout, {
    total: absoluteTotal
  }), /*#__PURE__*/_react.default.createElement(_alerting_callout.AlertingCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_search_field.SearchField, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_quick_filters.QuickFilters, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_filter_group.FilterGroup, {
    handleFilterChange: handleFilterChange
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), !noMonitorFound ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_overview_status.OverviewStatus, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    style: {
      minWidth: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_errors.OverviewErrors, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    style: {
      minWidth: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_alerts.OverviewAlerts, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_overview_grid.OverviewGrid, null)) : /*#__PURE__*/_react.default.createElement(_no_monitors_found.NoMonitorsFound, null));
};
exports.OverviewPage = OverviewPage;